/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.io.input.NullReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class NullReaderTest {
    private static final String MARK_RESET_NOT_SUPPORTED = "mark/reset not supported";

    @Test
    public void testRead() throws Exception {
        int size = 5;
        TestNullReader reader = new TestNullReader(5);
        for (int i = 0; i < 5; ++i) {
            Assertions.assertEquals((int)i, (int)reader.read(), (String)("Check Value [" + i + "]"));
        }
        Assertions.assertEquals((int)-1, (int)reader.read(), (String)"End of File");
        try {
            int result = reader.read();
            Assertions.fail((String)("Should have thrown an IOException, value=[" + result + "]"));
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)"Read after end of file", (Object)e.getMessage());
        }
        reader.close();
        Assertions.assertEquals((long)0L, (long)reader.getPosition(), (String)"Available after close");
    }

    @Test
    public void testReadCharArray() throws Exception {
        char[] chars = new char[10];
        TestNullReader reader = new TestNullReader(15);
        int count1 = ((Reader)((Object)reader)).read(chars);
        Assertions.assertEquals((int)chars.length, (int)count1, (String)"Read 1");
        for (int i = 0; i < count1; ++i) {
            Assertions.assertEquals((int)i, (int)chars[i], (String)"Check Chars 1");
        }
        int count2 = ((Reader)((Object)reader)).read(chars);
        Assertions.assertEquals((int)5, (int)count2, (String)"Read 2");
        for (int i = 0; i < count2; ++i) {
            Assertions.assertEquals((int)(count1 + i), (int)chars[i], (String)"Check Chars 2");
        }
        int count3 = ((Reader)((Object)reader)).read(chars);
        Assertions.assertEquals((int)-1, (int)count3, (String)"Read 3 (EOF)");
        try {
            int count4 = ((Reader)((Object)reader)).read(chars);
            Assertions.fail((String)("Should have thrown an IOException, value=[" + count4 + "]"));
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)"Read after end of file", (Object)e.getMessage());
        }
        ((Reader)((Object)reader)).close();
        int offset = 2;
        int lth = 4;
        int count5 = ((Reader)((Object)reader)).read(chars, 2, 4);
        Assertions.assertEquals((int)4, (int)count5, (String)"Read 5");
        for (int i = 2; i < 4; ++i) {
            Assertions.assertEquals((int)i, (int)chars[i], (String)"Check Chars 3");
        }
    }

    @Test
    public void testEOFException() throws Exception {
        TestNullReader reader = new TestNullReader(2, false, true);
        Assertions.assertEquals((int)0, (int)((Reader)((Object)reader)).read(), (String)"Read 1");
        Assertions.assertEquals((int)1, (int)((Reader)((Object)reader)).read(), (String)"Read 2");
        try {
            int result = ((Reader)((Object)reader)).read();
            Assertions.fail((String)("Should have thrown an EOFException, value=[" + result + "]"));
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        ((Reader)((Object)reader)).close();
    }

    @Test
    public void testMarkAndReset() throws Exception {
        int i;
        int position = 0;
        int readlimit = 10;
        TestNullReader reader = new TestNullReader(100, true, false);
        Assertions.assertTrue((boolean)((Reader)((Object)reader)).markSupported(), (String)"Mark Should be Supported");
        try {
            ((Reader)((Object)reader)).reset();
            Assertions.fail((String)"Read limit exceeded, expected IOException ");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)"No position has been marked", (Object)e.getMessage(), (String)"No Mark IOException message");
        }
        while (position < 3) {
            Assertions.assertEquals((int)position, (int)((Reader)((Object)reader)).read(), (String)("Read Before Mark [" + position + "]"));
            ++position;
        }
        ((Reader)((Object)reader)).mark(10);
        for (i = 0; i < 3; ++i) {
            Assertions.assertEquals((int)(position + i), (int)((Reader)((Object)reader)).read(), (String)("Read After Mark [" + i + "]"));
        }
        ((Reader)((Object)reader)).reset();
        for (i = 0; i < 11; ++i) {
            Assertions.assertEquals((int)(position + i), (int)((Reader)((Object)reader)).read(), (String)("Read After Reset [" + i + "]"));
        }
        try {
            ((Reader)((Object)reader)).reset();
            Assertions.fail((String)"Read limit exceeded, expected IOException ");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)("Marked position [" + position + "] is no longer valid - passed the read limit [" + 10 + "]"), (Object)e.getMessage(), (String)"Read limit IOException message");
        }
        ((Reader)((Object)reader)).close();
    }

    @Test
    public void testMarkNotSupported() throws Exception {
        TestNullReader reader = new TestNullReader(100, false, true);
        Assertions.assertFalse((boolean)((Reader)((Object)reader)).markSupported(), (String)"Mark Should NOT be Supported");
        try {
            ((Reader)((Object)reader)).mark(5);
            Assertions.fail((String)"mark() should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            Assertions.assertEquals((Object)MARK_RESET_NOT_SUPPORTED, (Object)e.getMessage(), (String)"mark() error message");
        }
        try {
            ((Reader)((Object)reader)).reset();
            Assertions.fail((String)"reset() should throw UnsupportedOperationException");
        }
        catch (UnsupportedOperationException e) {
            Assertions.assertEquals((Object)MARK_RESET_NOT_SUPPORTED, (Object)e.getMessage(), (String)"reset() error message");
        }
        ((Reader)((Object)reader)).close();
    }

    @Test
    public void testSkip() throws Exception {
        TestNullReader reader = new TestNullReader(10, true, false);
        Assertions.assertEquals((int)0, (int)((Reader)((Object)reader)).read(), (String)"Read 1");
        Assertions.assertEquals((int)1, (int)((Reader)((Object)reader)).read(), (String)"Read 2");
        Assertions.assertEquals((long)5L, (long)((Reader)((Object)reader)).skip(5L), (String)"Skip 1");
        Assertions.assertEquals((int)7, (int)((Reader)((Object)reader)).read(), (String)"Read 3");
        Assertions.assertEquals((long)2L, (long)((Reader)((Object)reader)).skip(5L), (String)"Skip 2");
        Assertions.assertEquals((long)-1L, (long)((Reader)((Object)reader)).skip(5L), (String)"Skip 3 (EOF)");
        try {
            ((Reader)((Object)reader)).skip(5L);
            Assertions.fail((String)"Expected IOException for skipping after end of file");
        }
        catch (IOException e) {
            Assertions.assertEquals((Object)"Skip after end of file", (Object)e.getMessage(), (String)"Skip after EOF IOException message");
        }
        ((Reader)((Object)reader)).close();
    }

    private static final class TestNullReader
    extends NullReader {
        public TestNullReader(int size) {
            super((long)size);
        }

        public TestNullReader(int size, boolean markSupported, boolean throwEofException) {
            super((long)size, markSupported, throwEofException);
        }

        protected int processChar() {
            return (int)this.getPosition() - 1;
        }

        protected void processChars(char[] chars, int offset, int length) {
            int startPos = (int)this.getPosition() - length;
            for (int i = offset; i < length; ++i) {
                chars[i] = (char)(startPos + i);
            }
        }
    }
}

