/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.QueueInputStream;
import org.apache.commons.io.output.QueueOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class QueueInputStreamTest {
    public static Stream<Arguments> inputData() {
        return Stream.of(Arguments.of((Object[])new Object[]{""}), Arguments.of((Object[])new Object[]{"1"}), Arguments.of((Object[])new Object[]{"12"}), Arguments.of((Object[])new Object[]{"1234"}), Arguments.of((Object[])new Object[]{"12345678"}), Arguments.of((Object[])new Object[]{StringUtils.repeat((String)"A", (int)4095)}), Arguments.of((Object[])new Object[]{StringUtils.repeat((String)"A", (int)4096)}), Arguments.of((Object[])new Object[]{StringUtils.repeat((String)"A", (int)4097)}), Arguments.of((Object[])new Object[]{StringUtils.repeat((String)"A", (int)8191)}), Arguments.of((Object[])new Object[]{StringUtils.repeat((String)"A", (int)8192)}), Arguments.of((Object[])new Object[]{StringUtils.repeat((String)"A", (int)8193)}), Arguments.of((Object[])new Object[]{StringUtils.repeat((String)"A", (int)32768)}));
    }

    @ParameterizedTest(name="inputData={0}")
    @MethodSource(value={"inputData"})
    public void unbufferedReadWrite(String inputData) throws IOException {
        try (QueueInputStream inputStream = new QueueInputStream();
             QueueOutputStream outputStream = inputStream.newQueueOutputStream();){
            this.writeUnbuffered(outputStream, inputData);
            String actualData = this.readUnbuffered((InputStream)inputStream);
            Assertions.assertEquals((Object)inputData, (Object)actualData);
        }
    }

    @ParameterizedTest(name="inputData={0}")
    @MethodSource(value={"inputData"})
    public void bufferedReads(String inputData) throws IOException {
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        try (BufferedInputStream inputStream = new BufferedInputStream((InputStream)new QueueInputStream(queue));
             QueueOutputStream outputStream = new QueueOutputStream(queue);){
            outputStream.write(inputData.getBytes(StandardCharsets.UTF_8));
            String actualData = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            Assertions.assertEquals((Object)inputData, (Object)actualData);
        }
    }

    @ParameterizedTest(name="inputData={0}")
    @MethodSource(value={"inputData"})
    public void bufferedWrites(String inputData) throws IOException {
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        try (QueueInputStream inputStream = new QueueInputStream(queue);
             BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)new QueueOutputStream(queue), this.defaultBufferSize());){
            outputStream.write(inputData.getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
            String actualData = this.readUnbuffered((InputStream)inputStream);
            Assertions.assertEquals((Object)inputData, (Object)actualData);
        }
    }

    @ParameterizedTest(name="inputData={0}")
    @MethodSource(value={"inputData"})
    public void bufferedReadWrite(String inputData) throws IOException {
        LinkedBlockingQueue queue = new LinkedBlockingQueue();
        try (BufferedInputStream inputStream = new BufferedInputStream((InputStream)new QueueInputStream(queue));
             BufferedOutputStream outputStream = new BufferedOutputStream((OutputStream)new QueueOutputStream(queue), this.defaultBufferSize());){
            outputStream.write(inputData.getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
            String dataCopy = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            Assertions.assertEquals((Object)inputData, (Object)dataCopy);
        }
    }

    @Test
    public void testNullArgument() {
        Assertions.assertThrows(NullPointerException.class, () -> new QueueInputStream(null), (String)"queue is required");
    }

    private int defaultBufferSize() {
        return 8192;
    }

    private void writeUnbuffered(QueueOutputStream outputStream, String inputData) throws InterruptedIOException {
        byte[] bytes;
        for (byte oneByte : bytes = inputData.getBytes(StandardCharsets.UTF_8)) {
            outputStream.write((int)oneByte);
        }
    }

    private String readUnbuffered(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = -1;
        while ((n = inputStream.read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        return byteArrayOutputStream.toString("UTF-8");
    }
}

