using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

namespace BufferedInput
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;
        SpriteFont Font;
        string TextBuffer;

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            // TODO: Add your initialization logic here

            // Initialise EventInput allowing it to hook in
            EventInput.EventInput.Initialize(Window);
            // Add event for character entered
            EventInput.EventInput.CharEntered += new EventInput.CharEnteredHandler(CharacterEntered);
            TextBuffer = "";

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            // TODO: use this.Content to load your game content here
            // Load font
            Font = Content.Load<SpriteFont>("Font");
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Called by EventInput class everytime key is pressed.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void CharacterEntered(object sender, EventInput.CharacterEventArgs e)
        {
            // Add key to text buffer. If not a symbol key. 
            if (!((int)e.Character < 32 || (int)e.Character > 126)) //From space to tilde
            {
                // Capitals are already supported in DLL so we don't have to worry about checking shift
                if (!(Keyboard.GetState().IsKeyDown(Keys.LeftControl) || Keyboard.GetState().IsKeyDown(Keys.RightControl)))
                {
                    TextBuffer += e.Character;
                }
            }

            // Backspace - remove character if there are any
            if ((int)e.Character == 0x08 && TextBuffer.Length > 0)
            {
                TextBuffer = TextBuffer.Remove(TextBuffer.Length - 1);
            }
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            // TODO: Add your update logic here

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.CornflowerBlue);

            spriteBatch.Begin();
            
            // Draw instructions
            Vector2 textPosition = new Vector2(20, 20);
            spriteBatch.DrawString(Font, "Begin typing to see it in the middle!", textPosition, Color.Black);

            // Draw our textbuffer in the middle of the screen
            Vector2 messageSize = Font.MeasureString(TextBuffer);
            textPosition = new Vector2((GraphicsDevice.Viewport.Width / 2) - (messageSize.X / 2),
                (GraphicsDevice.Viewport.Height / 2) - (messageSize.Y / 2));

            spriteBatch.DrawString(Font, TextBuffer, textPosition, Color.Black);

            spriteBatch.End();
            base.Draw(gameTime);
        }
    }
}
