/**
 * ****************************************************************************
 *
 * Classification: UNCLASSIFIED
 *
 * $Header: /cvsroot/img-browse-sort/jibs-swing/com/saic/isd/printscreen/ImageSelection.java,v 1.7 2007/01/14 18:25:13 gerhardb Exp $
 *
 * SAIC (C) Copyright 2004 Science Applications International Corporation.
 * All Rights Reserved.
 *
 * Developed by Science Applications International Corporation under
 * contract to the Department of Defense. All government restrictions
 * on software distribution apply.
 *
 * Subject to the GNU LESSER GENERAL PUBLIC LICENSE,
 * Version 2.1, February 1999 http://www.gnu.org/copyleft/lesser.html
 * A copy of that license is included with the source distribution.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * ****************************************************************************
 */
package com.saic.isd.printscreen;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.gerhardb.lib.image.IOImage;

/**
 * Ideas borrowed from Sun's code.
 * Replace with Sun's ImageSelect once Java 1.4 comes out.
 */
public class ImageSelection 
    implements ClipboardOwner, Transferable
{
   //private static final int JPEG = 0;
   private static final DataFlavor[] flavors =
   {
       new DataFlavor("image/x-java-image; class=java.awt.Image", "Image" ), //$NON-NLS-1$ //$NON-NLS-2$
       DataFlavor.javaFileListFlavor
   };
   
   private IOImage myIOImage;
   private List<File> myCurrentSelectedImageFiles;
   
   public ImageSelection( IOImage currentImage )
   {
      this.myIOImage = currentImage;
   }

   public ImageSelection( IOImage currentImage, File[] selectedImageFiles )
   {
      this.myIOImage = currentImage;
      this.myCurrentSelectedImageFiles = new ArrayList<File>(selectedImageFiles.length);
      for(File file: selectedImageFiles)
      {
      	this.myCurrentSelectedImageFiles.add(file);
      }
   }
   // =========================================================================
   //                        Transferable Interface
   // =========================================================================
   /**
    * Returns an array of flavors in which this Transferable can provide
    * the data. <code>DataFlavor.stringFlavor</code> is properly supported.
    * Support for <code>DataFlavor.plainTextFlavor</code> is
    * <b>deprecated</b>.
    *
    * @return an array of length two, whose elements are <code>DataFlavor.
    *         stringFlavor</code> and <code>DataFlavor.plainTextFlavor</code>.
    */
   public DataFlavor[] getTransferDataFlavors()
   {
      // returning flavors itself would allow client code to modify
      // our internal behavior
      return flavors.clone();
   }

   /**
    * Returns whether the requested flavor is supported by this Transferable.
    *
    * @param flavor the requested flavor for the data
    * @return true if <code>flavor</code> is equal to
    *   <code>DataFlavor.stringFlavor</code> or
    *   <code>DataFlavor.plainTextFlavor</code>; false if <code>flavor</code>
    *   is not one of the above flavors
    * @throws NullPointerException if flavor is <code>null</code>
    */
   public boolean isDataFlavorSupported( DataFlavor flavor )
   {
      if ( flavor == null )
      {
         return false;
      }
      for ( int i = 0; i < flavors.length; i++ )
      {
         if ( flavor.equals( flavors[i] ) )
         {
            return true;
         }
      }
      return false;
   }

   /**
    * Returns the Transferable's data in the requested DataFlavor if
    * possible. If the desired flavor is <code>DataFlavor.stringFlavor</code>,
    * or an equivalent flavor, the String representing the selection is
    * returned. If the desired flavor is </code>DataFlavor.plainTextFlavor
    * </code>, or an equivalent flavor, a Reader is returned. <b>Note:<b>
    * The behavior of this method for </code>DataFlavor.plainTextFlavor</code>
    * and equivalent DataFlavors is inconsistent with the definition of
    * <code>DataFlavor.plainTextFlavor</code>.
    *
    * @param flavor the requested flavor for the data
    * @return the data in the requested flavor, as outlined above.
    * @throws UnsupportedFlavorException if the requested data flavor is
    *         not equivalent to either <code>DataFlavor.stringFlavor</code>
    *         or <code>DataFlavor.plainTextFlavor</code>.
    * @throws IOException if an IOException occurs while retrieving the data.
    *         By default, StringSelection never throws this exception, but a
    *         subclass may.
    * @throws NullPointerException if flavor is <code>null</code>
    * @see java.io.Reader
    */
   public Object getTransferData( DataFlavor flavor )
       throws UnsupportedFlavorException
   {
      if ( flavor.equals( flavors[0] ) ) // image
      {
         return this.myIOImage.getImage();
      }
      else if ( flavor.equals(flavors[1])) // File
      {
      	if (this.myCurrentSelectedImageFiles != null)
      	{
      		return this.myCurrentSelectedImageFiles;
      	}
      	List<File> rtnMe = new ArrayList<File>(1);
      	rtnMe.add(this.myIOImage.getFile());
      	return rtnMe;
      }
      throw new UnsupportedFlavorException( flavor );
   }

   // =========================================================================
   //                        ClipboardOwner Interface
   // =========================================================================
   public void lostOwnership( Clipboard clipboard, Transferable contents )
   {
		// We don't care
   }
}
/*
 http://www.rockhoppertech.com/java-drag-and-drop-faq.html#nativeimages
 Why can't I drop images into a native application?
 There are several things you need to do first.
 You need a Transferable that can provide the image data in a format that
 the application likes. You will not be able to drop a serialized ImageIcon
 onto a native app for example. Most won't accept a binary stream even if you
 declare it's MIME type (e.g. image/jpeg) either.
 You need to know what the native "clipboard" formats are.
 For example on Win32,
 DIB (device independent bitmap) and BITMAP are clipboard image formats.
 Learn the format and write an InputStream the can provide it.
 Then add your stream to a FlavorMap.
 What is a FlavorMap and why do I need one?
 Most native apps don't understand MIME types for data transfer.
 They have their own "clipboard" types. Java DataFlavors are based
 on MIME types.
 In order to provide a mapping between the win32 format TEXT and MIME
 types text/plain;charset=ascii you create a FlavorMap. Actually the default
 system flavormap does this type for you. An easy way to add mappings
 is to edit
 $JDKHOME/jre/lib/flavormap.properties. For our custom image stream we've added
 the following entry:
 DIB=image/x-win-bmp;class=com.rockhoppertech.dnd.datatransfer.BitmapInputStream
 Other Win32 clipboard formats are:
 WAVE
 RIFF
 PALETTE
 ENHMETAFILE
 METAFILEPICT
 DIB
 TIFF
 How
 */
