/*
Copyright (c) 2001 SAIC.  All rights reserved.

Subject to the GNU LESSER GENERAL PUBLIC LICENSE,
Version 2.1, February 1999 http://www.gnu.org/copyleft/lesser.html

THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SAIC OR
ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY
OF SUCH DAMAGE.
*/
package com.saic.isd.util;

// Java import statements
import java.util.Arrays;
import java.util.List;

/**
 * Provides easy access to command line parameters.
 * <P>
 * @author  C Meiburg (originator)
 */
public class ArgList
{
   List<String> myList;

   /**
    * Creates a holder for arguments.
    * @param args from main()
    */
    public ArgList(String [] args)
    {
       // There is no need to trim anything because
       // the main uses spaces as token separaters.
       this.myList = Arrays.asList(args);
    }

    /**
     * Get a particular setting.
     * @param aOptionKey If you are using -x option pass in "-x"
     * @return the option setting or null if not found.
     */
    public String getOption(String aOptionKey)
    {
        return getOption(aOptionKey, null);
    }

    /**
     * Get a particular setting.
     * @param aOptionKey If you are using -x option pass in "-x"
     * @param defaultValue default value to use if noting his found.
     * @return the option setting or default if not found.
     */
    public String getOption(String aOptionKey, String defaultValue)
    {
        String option = defaultValue;
        if (this.myList.contains(aOptionKey))
        {
            int index = this.myList.indexOf(aOptionKey) + 1;
            if ( this.myList.size() > index )
            {
               option = this.myList.get(index);
            }
        }
        return option;
    }

    /**
     * Checks to see if the setting was made.
     * @param aOption If you are using -x option pass in "-x"
     * @return true if the setting was made.
     */
    public boolean isOption(String aOption)
    {
        return this.myList.contains(aOption);
    }
}
