/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.jibs;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;

import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ScrollPaneConstants;

import org.gerhardb.lib.swing.SwingUtils;

public class LicenseBox extends Dialog implements ActionListener
{
	JButton myOkBtn = new JButton();

	public LicenseBox(Frame parent)
	{
		super(parent);
		enableEvents(AWTEvent.WINDOW_EVENT_MASK);
		try
		{
			jbInit();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		this.setSize(600,400);
		super.setModal(true);
		SwingUtils.centerOnScreen(this);
		super.setVisible(true);
	}

	private void jbInit() throws Exception
	{
		super.setTitle(Jibs.getString("LicenseBox.license")); //$NON-NLS-1$
		super.setResizable(true);

		String licenseResource = "license.html";  //$NON-NLS-1$
		String thisLine;
		StringBuffer buff = new StringBuffer(3000);
		try
		{
			InputStream is = getClass().getResourceAsStream(licenseResource);
			BufferedReader br = new BufferedReader(new InputStreamReader(is));
			while ((thisLine = br.readLine()) != null)
			{
				buff.append(thisLine);
			}
			is.close();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}

		String html = buff.toString();
		System.out.println(html);

      JEditorPane editorPane = new JEditorPane();
      editorPane.setEditable(false);
      editorPane.setDisabledTextColor(Color.black);
      editorPane.setEditorKit(
         JEditorPane.createEditorKitForContentType("text/html")); //$NON-NLS-1$
      editorPane.setText(html);

      JScrollPane center = new JScrollPane(
                           editorPane,
                           ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED,
                           ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER
                           );

		this.myOkBtn.setText(Jibs.getString("ok")); //$NON-NLS-1$
		this.myOkBtn.addActionListener(this);
		
		JPanel basePanel = new JPanel(new BorderLayout());
		basePanel.add(center, BorderLayout.CENTER);
		basePanel.add(this.myOkBtn, BorderLayout.SOUTH);
		
		this.add(basePanel, null);
	} 

	@Override
	protected void processWindowEvent(WindowEvent e)
	{
		if (e.getID() == WindowEvent.WINDOW_CLOSING)
		{
			cancel();
		}
		super.processWindowEvent(e);
	}

	void cancel()
	{
		dispose();
	}

	public void actionPerformed(ActionEvent e)
	{
		if (e.getSource() == this.myOkBtn)
		{
			cancel();
		}
	}

	//==========================================================================
	//                         Menu
	//==========================================================================
	public static void main(String[] args)
	{
		try
		{
			JFrame f = new JFrame("File Tree Test"); //$NON-NLS-1$
			f.getContentPane().add(new JLabel("test")); //$NON-NLS-1$
			f.setSize(300, 300);
			f.addWindowListener(new WindowAdapter()
			{
				@Override
				public void windowClosing(WindowEvent evt)
				{
					System.exit(0);
				}
			});
			f.setVisible(true);
			new LicenseBox(f);
		}
		catch (Exception ex)
		{
			System.out.println(ex.getMessage());
		}

		System.out.println("Main Exiting Normally"); //$NON-NLS-1$
	} // Main method

} // LicenseBox
