/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.jibs.concatenater;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.prefs.Preferences;

import javax.swing.DefaultBoundedRangeModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.io.DirectoriesOnlyFileFilter;
import org.gerhardb.lib.io.DragDropList;
import org.gerhardb.lib.swing.JFileChooserExtra;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;
import org.gerhardb.lib.util.StopCheckButton;

/**
 */

public class Concatenater extends JFrame
{
	public static String APP_NAME = "Concatenate";
	private static final String LAST_DIR = "ConcatFrame.LastDir"; //$NON-NLS-1$

	static final Preferences clsPrefs = Preferences.userRoot().node(
			"/org/gerhardb/app/imgbrowse/ConcatFrame"); //$NON-NLS-1$

	JTextField myFileName = new JTextField(60);

	DefaultListModel myFiles = new DefaultListModel();

	JList myFileList = new DragDropList(this.myFiles, true);
	StopCheckButton myStopCheckBtn;

	DefaultBoundedRangeModel myRange = new DefaultBoundedRangeModel();
	JProgressBar myBar = new JProgressBar(this.myRange);

	public Concatenater(boolean iExitOnClose)
	{
		super(Jibs.getString("Concatenater.3")); //$NON-NLS-1$
		this.myStopCheckBtn = new StopCheckButton();

		if (iExitOnClose)
		{
			this.addWindowListener(new WindowAdapter()
			{
				@Override
				public void windowClosing(WindowEvent evt)
				{
					System.exit(0);
				}
			});
		}
		layoutComponents();

		this.setIconImage(Icons.getIcon(Icons.JIBS_16).getImage());

		EventQueue.invokeLater(new Runnable()
		{
			public void run()
			{
				Concatenater.this.pack();
				Concatenater.this.setVisible(true);
				SwingUtils.centerOnScreen(Concatenater.this);
			}
		});
	}
	
	private void layoutComponents()
	{
		// Set up application
		this.setSize(new Dimension(600, 600));

		JButton addBtn = new JButton(Jibs.getString("Concatenater.4")); //$NON-NLS-1$
		addBtn.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent evt)
			{
				Concatenater.this.myRange.setValue(0);
				Concatenater.this.myBar.setStringPainted(false);
				addFiles();
			}
		});

		JButton doBtn = new JButton(Jibs.getString("Concatenater.5")); //$NON-NLS-1$
		doBtn.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent evt)
			{
				concat();
			}
		});            
   	
		JButton clearBtn = new JButton(Jibs.getString("Concatenater.6")); //$NON-NLS-1$
		clearBtn.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent evt)
			{
				Concatenater.this.myRange.setValue(0);
				Concatenater.this.myBar.setStringPainted(false);
				Concatenater.this.myFiles.clear();
				Concatenater.this.myFileName.setText(""); //$NON-NLS-1$
			}
		});

      final JButton btnToDirectory = new JButton("..."); //$NON-NLS-1$
      btnToDirectory.addActionListener
         (
         new ActionListener()
      {
         public void actionPerformed(ActionEvent ae)
         {
            File currFile = new File(Concatenater.this.myFileName.getText());
            
         	final String LAST = "lastDir"; //$NON-NLS-1$
            String lastDirectory = clsPrefs.get(LAST, null);
            if (lastDirectory == null)
            {
            	lastDirectory = System.getProperty("user.home"); //$NON-NLS-1$
            }
            lastDirectory = DirectoriesOnlyFileFilter.lookupDir("Joined file directory", lastDirectory, Concatenater.this); //$NON-NLS-1$
            if (lastDirectory != null)
            {
            	clsPrefs.put(LAST, lastDirectory);
            	Concatenater.this.myFileName.setText(lastDirectory + File.separator + currFile.getName());
            }
         }
      }
      );
      
		JPanelRows topPanel = new JPanelRows(FlowLayout.CENTER);
		JPanel row = topPanel.topRow();
		row.add(new JLabel(Jibs.getString("Concatenater.8"))); //$NON-NLS-1$

		row = topPanel.nextRow();
		row.add(new JLabel(Jibs.getString("Concatenater.11"))); //$NON-NLS-1$

		JPanelRows bottomPanel = new JPanelRows();
		row = bottomPanel.topRow(FlowLayout.CENTER);
		row.add(addBtn);
		row.add(clearBtn);

		row = bottomPanel.nextRow();
		row.add(new JLabel(Jibs.getString("Concatenater.13") + Jibs.getString("colon") + " ")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		row.add(this.myFileName);
		row.add(btnToDirectory);

		row = bottomPanel.nextRow(FlowLayout.CENTER);
		row.add(doBtn);
		row.add(this.myStopCheckBtn.getStopButton());

		row = bottomPanel.nextRow(FlowLayout.CENTER);
		Dimension dim = this.myBar.getPreferredSize();
		dim.width = 500;
		this.myBar.setPreferredSize(dim);
		// JPanel rangePanel = new JPanel(new BorderLayout());
		// rangePanel.add(new JProgressBar(myRange), BorderLayout.CENTER);
		row.add(this.myBar);

		JScrollPane middle = new JScrollPane(this.myFileList);

		// Set up content pane
		JPanel thePanel = new JPanel(new BorderLayout());
		thePanel.add(topPanel, BorderLayout.NORTH);
		thePanel.add(middle, BorderLayout.CENTER);
		thePanel.add(bottomPanel, BorderLayout.SOUTH);
		this.setContentPane(new JScrollPane(thePanel));
	}

	void addFiles()
	{
		String lastDir = clsPrefs.get(LAST_DIR, null);
		JFileChooserExtra chooser = new JFileChooserExtra(lastDir);
		chooser.setSaveName(APP_NAME, Jibs.getString("Concatenater.14")); //$NON-NLS-1$
		chooser.setDialogTitle(Jibs.getString("Concatenater.15")); //$NON-NLS-1$
		chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		chooser.setMultiSelectionEnabled(true);

		int returnVal = chooser.showOpenDialog(this);
		if (returnVal == JFileChooser.APPROVE_OPTION)
		{
			File[] picked = chooser.getSelectedFiles();
			if (picked[0] != null)
			{
				this.myFileName.setText(picked[0].toString());
			}

			try
			{
				clsPrefs.put(LAST_DIR, chooser.getCurrentDirectory().toString());
				clsPrefs.flush();
			}
			catch (Exception ex)
			{
				ex.printStackTrace();
			}
			for (int i = 0; i < picked.length; i++)
			{
				this.myFiles.addElement(picked[i]);
			}
		}
	}

	void concat()
	{
 		Object[] obj = this.myFiles.toArray();
		File[] files = new File[obj.length];
		for (int i = 0; i < obj.length; i++)
		{
        	files[i] = new File(obj[i].toString());
		}
		ThreadedConcatenater tc = new ThreadedConcatenater(new File(this.myFileName.getText()), files,
				this, this.myStopCheckBtn, this.myRange, this.myBar, true);
		new Thread(tc).start();
	}

	// ===========================================================================
	// Main
	// ===========================================================================
	public static void main(String[] args)
	{
		new Concatenater(true);
	}
}
