/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.gerhardb.jibs.concatenater;

import java.awt.Cursor;
import java.io.File;

import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.io.FileUtil;
import org.gerhardb.lib.util.StopCheckButton;

/**
 */

class ThreadedConcatenater implements Runnable
{
	JFrame myFrame;
	StopCheckButton myStopCheckBtn;
	DefaultBoundedRangeModel myRange;
	JProgressBar myBar;
	File myTo;
	File[] myFrom;
	boolean iShowDone = false;

	ThreadedConcatenater(File to, File[] from, JFrame f, StopCheckButton s, DefaultBoundedRangeModel d, JProgressBar b, boolean showDone)
	{
		this.myTo = to;
		this.myFrom = from;
		this.myFrame = f;
		this.myStopCheckBtn = s;
		this.myRange = d;
		this.myBar = b;
		this.iShowDone = showDone;
	}
	
	public void run()
	{
		this.myStopCheckBtn.start();
		try
		{
			SwingUtilities.invokeLater(new Runnable()
			{
				public void run()
				{
					ThreadedConcatenater.this.myFrame.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
				}
			});
			this.myBar.setStringPainted(true);
			this.myBar.setString(this.myTo.getName()); 
			FileUtil.concatFiles(this.myTo, this.myFrom, this.myRange, this.myStopCheckBtn);
			if (this.iShowDone)
			{
				this.myBar.setString(this.myTo.getName()
					+ " " + Jibs.getString("Concatenater.0")); //$NON-NLS-1$ //$NON-NLS-2$
			}
		}
		catch (final Exception ex)
		{
			this.myBar.setStringPainted(true);
			this.myBar.setString(this.myTo.getName()
					+ " " + Jibs.getString("Concatenater.18")); //$NON-NLS-1$ //$NON-NLS-2$
			ex.printStackTrace();
			SwingUtilities.invokeLater(new Runnable()
			{
				public void run()
				{
					JOptionPane.showMessageDialog(ThreadedConcatenater.this.myFrame,
							ex.getMessage(), Jibs.getString("Concatenater.16"), //$NON-NLS-1$
							JOptionPane.ERROR_MESSAGE);
				}
			});
		}
		finally
		{
			SwingUtilities.invokeLater(new Runnable()
			{
				public void run()
				{
					ThreadedConcatenater.this.myFrame.setCursor(Cursor.getDefaultCursor());
				}
			});
			this.myStopCheckBtn.done();
		}
	}
}
