/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.jibs.dirtools;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;

import javax.swing.*;

import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.io.FileUtil;
import org.gerhardb.lib.swing.JPanelRows;
import com.saic.isd.printscreen.Util;
import com.saic.isd.util.report.Report;

/**
 * User interface for the directory utilities.
 */
public class DirDedupPanel
   extends JPanelRows
{
   private static Preferences clsPrefs = Preferences.userRoot().node("/org/gerhardb/jibs/dirtools/DirDedupPanel");
   static String SACRED_STABLE_DIR = "SACRED_STABLE_DIR";
   static String DEDUP_TARGET_DIR = "DEDUP_TARGET_DIR";
   
   WorkerDedup myWorker;
   
   JLabel myCurrentAction = new JLabel("Idle");

   private static final int DIR_COL_WIDTH = 50;
   JTextField sacredStableDirFld;
   JTextField dedupTargetDirFld;
   JButton myStartBtn = new JButton(Jibs.getString("CameraPanel.3")); //$NON-NLS-1$
 	JButton myStopBtn = new JButton(Jibs.getString("CameraPanel.16")); //$NON-NLS-1$
 	JCheckBox myCheckFileContents = new JCheckBox("Use File Name Only");

   //===========================================================================
   //                          Constructor
   //===========================================================================

   public DirDedupPanel()
   {
      super();
      this.myCheckFileContents.setSelected(false);
      
      // Layout Sacred Stable
      String stableDir = FileUtil.checkDirectory(clsPrefs.get(
      		SACRED_STABLE_DIR,
            System.getProperty("user.home")));
      // In case directory erased somehow.
      if (stableDir == null)
      {
      	stableDir = System.getProperty("user.home");
      }
      this.sacredStableDirFld = new JTextField(stableDir);
      this.sacredStableDirFld.setColumns(DIR_COL_WIDTH);

      JButton btnSacredStable = new JButton("..."); //$NON-NLS-1$
      btnSacredStable.addActionListener
         (
         new ActionListener()
      {
         public void actionPerformed(ActionEvent ae)
         {
            String dir = DirDedupPanel.this.sacredStableDirFld.getText();
            if (dir == null)
            {
               dir = System.getProperty("user.home"); //$NON-NLS-1$
            }
            dir = lookupDir("Stable Directory", dir); //$NON-NLS-1$
            DirDedupPanel.this.sacredStableDirFld.setText(dir);
            setPrefsDirectory(SACRED_STABLE_DIR,dir);
         }
      }
      );

      // Layout Target Dedup
      String dedupTarget = FileUtil.checkDirectory(clsPrefs.get(
      		DEDUP_TARGET_DIR,
            System.getProperty("user.home")));
      if (dedupTarget == null)
      {
      	dedupTarget = System.getProperty("user.home"); //$NON-NLS-1$
      }
      this.dedupTargetDirFld = new JTextField(dedupTarget);
      this.dedupTargetDirFld.setColumns(DIR_COL_WIDTH);

      JButton btnDedupTarget = new JButton("..."); //$NON-NLS-1$
      btnDedupTarget.addActionListener
         (
         new ActionListener()
      {
         public void actionPerformed(ActionEvent ae)
         {
            String dir = DirDedupPanel.this.dedupTargetDirFld.getText();
            if (dir == null)
            {
               dir = System.getProperty("user.home"); //$NON-NLS-1$
            }
            dir = lookupDir("Target Dedup Directory", dir); //$NON-NLS-1$
            DirDedupPanel.this.dedupTargetDirFld.setText(dir);
            setPrefsDirectory(DEDUP_TARGET_DIR,dir);
         }
      }
      );

      this.myStopBtn.setEnabled(false);
      final JButton btnReport = new JButton(Jibs.getString("report")); //$NON-NLS-1$
      btnReport.setEnabled(false);

      this.myStartBtn.addActionListener(new java.awt.event.ActionListener()
      {
         public void actionPerformed(java.awt.event.ActionEvent evt)
         {
            doWork();
            btnReport.setEnabled(true);
            DirDedupPanel.this.myStopBtn.setEnabled(true);
         }
      });

      this.myStopBtn.addActionListener(new java.awt.event.ActionListener()
      {
         public void actionPerformed(java.awt.event.ActionEvent evt)
         {
         	DirDedupPanel.this.myWorker.stop();
         	DirDedupPanel.this.myStopBtn.setEnabled(false);            
         }
      });
      
      btnReport.addActionListener(new java.awt.event.ActionListener()
      {
         public void actionPerformed(java.awt.event.ActionEvent evt)
         {
            try
            {
               String text = Util.getTextFromFile(DirDedupPanel.this.myWorker.myLogFile);
               Report.showReport(
                  Jibs.getString("CameraPanel.30"), text, false); //$NON-NLS-1$
            }
            catch (Exception ex)
            {
               Report.showReport(
                  Jibs.getString("CameraPanel.20"), //$NON-NLS-1$
                  ex.getMessage(), false);
            }
         }
      });

      JPanel currentRow = super.topRow();
      currentRow.add(new JLabel("Removes from the dedup directory any files found in stable directory."));

      currentRow = super.nextRow();
      currentRow.add(new JLabel("Stable Directory (won't be changed): "));
      currentRow.add(this.sacredStableDirFld);
      currentRow.add(btnSacredStable);

      currentRow = super.nextRow();
      currentRow.add(new JLabel("Dedup Directory (remove from here): "));
      currentRow.add(this.dedupTargetDirFld);
      currentRow.add(btnDedupTarget);

      currentRow = super.nextRow();
      currentRow.add(this.myCheckFileContents);     
      
      currentRow = super.nextRow();
      currentRow.add(this.myStartBtn);
      currentRow.add(this.myStopBtn);
      currentRow.add(btnReport);

      currentRow = super.nextRow();
      currentRow.add(new JLabel(" " + " " + Jibs.getString("CameraPanel.18") + Jibs.getString("colon") + " ")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$ //$NON-NLS-5$
      currentRow.add(this.myCurrentAction);
   }

   String lookupDir(String msg, String prior)
   {
      JFileChooser chooser = new JFileChooser();
      chooser.setDialogTitle(msg);
      chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
      chooser.setCurrentDirectory(new File(prior));

      int returnVal = chooser.showOpenDialog(this);
      if (returnVal == JFileChooser.APPROVE_OPTION)
      {
         try
         {
            return chooser.getSelectedFile().getCanonicalPath();
         }
         catch (IOException ex)
         {
            ex.printStackTrace();
         }
      }
      return null;
   } 

   //===========================================================================
   //===========================================================================
   //                           WORK FUNCTIONS
   //===========================================================================
   //===========================================================================
   /**
    */
   void doWork()
   {
      try
      {
         this.myWorker = new WorkerDedup(this, this.sacredStableDirFld.getText(), 
         		this.dedupTargetDirFld.getText(), !this.myCheckFileContents.isSelected());
         Thread t = new Thread(this.myWorker);
         t.start();
      }
      catch (WorkerDedup.WorkerDedupException ex)
      {
      	// no stack trace
         JOptionPane.showMessageDialog(
            this,
            ex.getMessage(),
            Jibs.getString("CameraPanel.25"), //$NON-NLS-1$
            JOptionPane.ERROR_MESSAGE);
      }
      catch (Exception ex)
      {
         JOptionPane.showMessageDialog(
            this,
            ex.getMessage(),
            Jibs.getString("CameraPanel.25"), //$NON-NLS-1$
            JOptionPane.ERROR_MESSAGE);
         ex.printStackTrace();
      }
   }
  
   static void setPrefsDirectory(String pref, String dir)

   {
      String validated = FileUtil.safeValidateDirectory(dir);
      if (validated != null)
      {
         clsPrefs.put(pref, validated);
      }
      else
      {
         clsPrefs.remove(pref);
      }
   }
}
