package org.gerhardb.jibs.dirtools;

/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

import org.gerhardb.lib.io.DirListController;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;

/**
 * User interface for the directory utilities.
 */
public class DirectoryCopy
   extends JFrame
{
	public static String APP_NAME = "DirectoryCopy";
   boolean iExitOnClose;

   DirListController myIncludeList =
      new DirListController("Include", "DirToolsInclude", true, APP_NAME);
   
   DirListController myExcludeList =
      new DirListController("Exclude", "DirToolsExclude", true, APP_NAME);   
   
   //===========================================================================
   //                          Constructor
   //===========================================================================

   public DirectoryCopy(boolean exitOnClose)
   {
     init(exitOnClose);
   }

   void init(boolean exitOnClose)
   {
      this.iExitOnClose = exitOnClose;
      setTitle("JIBS Directory Copy"); //$NON-NLS-1$

      addWindowListener(
         new WindowAdapter()
      {
         @Override
			public void windowClosing(WindowEvent e)
         {
            exit();
         }
      }
      );

      enableEvents(AWTEvent.WINDOW_EVENT_MASK);
      try
      {
          //initMenuAndToolbar();
         layoutComponents();
      }
      catch (Exception e)
      {
         e.printStackTrace();
         System.out.println("*** Unkonwn abnormal termination ***");  //$NON-NLS-1$
         System.exit(99);
      }

		this.setIconImage(Icons.getIcon(Icons.JIBS_16).getImage());
      
      // Work on showing the frame!
      EventQueue.invokeLater(new Runnable()
      {
         public void run()
         {
            DirectoryCopy.this.validate();
            DirectoryCopy.this.pack();
            SwingUtils.centerOnScreen(DirectoryCopy.this);
            DirectoryCopy.this.setVisible(true);
         }
      });

   }

   //===========================================================================
   //                          Component Layout
   //===========================================================================
   private void layoutComponents()
      throws Exception
   {

      // Set up center panel
      JTabbedPane jTabbed = new JTabbedPane();
      jTabbed.addTab("Include", this.myIncludeList.getPanel());
      jTabbed.addTab("Exclude", this.myExcludeList.getPanel());
      jTabbed.addTab("Directory Copy", new DirCopyPanel(this)); //$NON-NLS-1$

      // Set up content pane
      JPanel thePanel = new JPanel(new BorderLayout());
      thePanel.add(jTabbed, BorderLayout.CENTER);
      this.setContentPane(new JScrollPane( thePanel ));
   } 


   void exit()
   {
      if (this.iExitOnClose)
      {
         System.exit(0);
      }
      else
      {
         // TODO: May want to kill any running worker thread.
         // Would need to track in here and manage from the actual workers
         // adding an interupt reutine to the workers.
         this.setVisible(false);
         dispose();
      }
   }

   //===========================================================================
   //                              Main
   //===========================================================================
   public static void main(String[] args)
   {
      new DirectoryCopy(true);
   }
}
