/**
 * ****************************************************************************
 *
 * Classification: UNCLASSIFIED
 *
 * SAIC (C) Copyright 2004 Science Applications International Corporation.
 * All Rights Reserved.
 *
 * Developed by Science Applications International Corporation under
 * contract to the Department of Defense. All government restrictions
 * on software distribution apply.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 * A copy of that license is included with the source distribution.
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * ****************************************************************************
 */
package org.gerhardb.jibs.obsolete;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;

import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.WindowConstants;

/**
 * Creates the illusion of a modal dialog, by disabling all mouse and
 * keyboard input to the owner window of a <code>JDialog</code>.  To
 * use this class, create an instance and call its <code>install</code>
 * method.
 *
 * @author Craig Pell &lt;pellc@saic.com&gt; (initial)
 * @author $Author: gerhardb $ (latest)
 * @author $Date: 2007/12/20 14:41:33 $
 */
public class DialogModality
{
   final Dialog dialog;

   /**
    * Creates an instance capable of blocking input to the parent
    * of the specified dialog whenever the specified dialog is
    * shown.  Note that none of the simulated modality will take
    * place until {@link #install()} is called.
    */
   public DialogModality(JDialog d)
   {
      this.dialog = d;
   }

   /**
    * Makes this object's dialog appear modal with
    * respect to its owner window.
    *
    * @see #uninstall()
    */
   public void install()
   {
      Window owner = this.dialog.getOwner();
      if (owner != null)
      {
         owner.addComponentListener(this.mouseBlockerSynchronizer);
      }
      KeyboardFocusManager k =
         KeyboardFocusManager.getCurrentKeyboardFocusManager();
      k.addVetoableChangeListener("focusedWindow", this.windowFocusPreventer); //$NON-NLS-1$

      Window parent = this.dialog.getOwner();

      if (parent instanceof RootPaneContainer)
      {
         JLayeredPane l = ((RootPaneContainer)parent).getLayeredPane();
         this.mouseBlocker.setSize(l.getSize());
         l.add(this.mouseBlocker, new Integer(Integer.MAX_VALUE));
      }
      else
      {
         // better than nothing...
         parent.setEnabled(false);
      }
   }

   /**
    * Removes all influences of this object over its dialog,
    * effectively undoing a call to {@link #install()}.
    */
   public void uninstall() // NO_UCD // NO_UCD
   {
      Window owner = this.dialog.getOwner();
      if (owner != null)
      {
         owner.removeComponentListener(this.mouseBlockerSynchronizer);
      }
      KeyboardFocusManager k =
         KeyboardFocusManager.getCurrentKeyboardFocusManager();
      k.removeVetoableChangeListener("focusedWindow", this.windowFocusPreventer); //$NON-NLS-1$

      Window parent = this.dialog.getOwner();

      if (parent instanceof RootPaneContainer)
      {
         JLayeredPane l = ((RootPaneContainer)parent).getLayeredPane();
         l.remove(this.mouseBlocker);
      }
      else
      {
         // better than nothing...
         parent.setEnabled(true);
      }
   }

   final Component mouseBlocker = new JPanel()
   {
      {
         setOpaque(false);
         enableEvents(AWTEvent.MOUSE_EVENT_MASK);
      }

      @Override
		protected void processMouseEvent(MouseEvent event)
      {
         /*
         if (logger.isLoggable(Level.FINE))
         {
            String type;
            switch (event.getID())
            {
               case MouseEvent.MOUSE_CLICKED:
                  type = "MOUSE_CLICKED";
                  break;
               case MouseEvent.MOUSE_PRESSED:
                  type = "MOUSE_PRESSED";
                  break;
               case MouseEvent.MOUSE_RELEASED:
                  type = "MOUSE_RELEASED";
                  break;
               case MouseEvent.MOUSE_ENTERED:
                  type = "MOUSE_ENTERED";
                  break;
               case MouseEvent.MOUSE_EXITED:
                  type = "MOUSE_EXITED";
                  break;
               default:
                  type = "(unknown)";
                  break;
            }
            logger.fine("Blocked mouse event: " + type);
         }
         */
         event.consume();
      }
   };

   private final ComponentListener mouseBlockerSynchronizer =
      new ComponentAdapter()
   {
      @Override
		public void componentResized(ComponentEvent event)
      {
         DialogModality.this.mouseBlocker.setSize(event.getComponent().getSize());
      }
   };

   private final VetoableChangeListener windowFocusPreventer =
      new VetoableChangeListener()
   {
      public void vetoableChange(PropertyChangeEvent event)
         throws PropertyVetoException
      {
         String property = event.getPropertyName();
         if (property.equals("focusedWindow")) //$NON-NLS-1$
         {

            Window owner = DialogModality.this.dialog.getOwner();
            if (owner != null && event.getNewValue() == owner)
            {
               EventQueue.invokeLater(this.refocuser);
               throw new PropertyVetoException(
                  "Window may not take focus" //$NON-NLS-1$
                  + " while it has a modal dialog showing", //$NON-NLS-1$
                  event);
            }
         }
      }

      private final Runnable refocuser = new Runnable()
      {
         public void run()
         {
            DialogModality.this.dialog.requestFocus();
         }
      };
   };

   /**
    * Tests this class by showing a frame with a button that causes a
    * single dialog, made "modal" by an instance of this class, to
    * appear.
    */
   public static void main(String[] args)
   {
      javax.swing.JFrame frame =
         new javax.swing.JFrame("DialogModality Test"); //$NON-NLS-1$
      frame.setDefaultCloseOperation(javax.swing.JFrame.EXIT_ON_CLOSE);

      final javax.swing.JDialog dialog =
         new javax.swing.JDialog(frame, "Modal Dialog", false); //$NON-NLS-1$
      dialog.setSize(200, 200);
      dialog.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);

      frame.getContentPane().add(new javax.swing.JButton(
         new javax.swing.AbstractAction("Show Dialog") //$NON-NLS-1$
      {
         public void actionPerformed(java.awt.event.ActionEvent event)
         {
            dialog.getToolkit().beep();
            dialog.setVisible(true);
         }
      }), java.awt.BorderLayout.PAGE_START);
      frame.setSize(300, 300);
      frame.setLocationRelativeTo(frame.getOwner());
      dialog.setLocationRelativeTo(dialog.getOwner());

      new DialogModality(dialog).install();

      frame.setVisible(true);
   }
}
