/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.jibs.optimizer;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.dirtree.rdp.RDPplugins;
import org.gerhardb.lib.io.DirListController;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;
import org.gerhardb.lib.util.Killer;

/**
 * User interface for the directory utilities.
 */
public class Optimizer
   extends JFrame
{
	public static String APP_NAME = "Optimizer";
	
   boolean iExitOnClose;
   DownloadPanel myDownloadPanel;
   DirListController myWorkingList =
      new DirListController("Working List", Jibs.getString("Optimizer.1"), false, APP_NAME); //$NON-NLS-1$ //$NON-NLS-2$
   DirListController myStableList =
      new DirListController("Stable List", Jibs.getString("Optimizer.3"), false, APP_NAME); //$NON-NLS-1$ //$NON-NLS-2$
   Killer myKiller = new Killer();
   RDPplugins myRDPplugins;

   //===========================================================================
   //                          Constructor
   //===========================================================================

   public Optimizer(File[] files, RDPplugins rdpPlugins)
   {
      this.myWorkingList.add(files);
      this.myRDPplugins = rdpPlugins;
      init(false);
   }

   public Optimizer(boolean exitOnClose, RDPplugins rdpPlugins)
   {
      this.myRDPplugins = rdpPlugins;
      init(exitOnClose);
   }

   void init(boolean exitOnClose)
   {
      this.iExitOnClose = exitOnClose;
      setTitle(Jibs.getString("Optimizer.4")); //$NON-NLS-1$
		this.setIconImage(Icons.getIcon(Icons.JIBS_16).getImage());
      try
      {
          OptimizerPreferences.init();
      }
      catch (Exception ex)
      {
         // Catch SecurityException and anything else that can go wrong.
         ex.printStackTrace();
         JOptionPane.showMessageDialog(
            this,
            Jibs.getString("Optimizer.5"), //$NON-NLS-1$
            Jibs.getString("Optimizer.6"), //$NON-NLS-1$
            JOptionPane.ERROR_MESSAGE);
      }

		this.setIconImage(Icons.getIcon(Icons.JIBS_16).getImage());
      addWindowListener(
         new WindowAdapter()
      {
         @Override
			public void windowClosing(WindowEvent e)
         {
            exit();
         }
      }
      );

      enableEvents(AWTEvent.WINDOW_EVENT_MASK);
      try
      {
         //initMenuAndToolbar();
         layoutComponents();
      }
      catch (Exception e)
      {
         e.printStackTrace();
         System.out.println(Jibs.getString("Optimizer.7")); //$NON-NLS-1$
         System.exit(99);
      }

      // Work on showing the frame!
      EventQueue.invokeLater(new Runnable()
      {
         public void run()
         {
            Optimizer.this.validate();
            Optimizer.this.pack();
            SwingUtils.centerOnScreen(Optimizer.this);
            Optimizer.this.setVisible(true);
         }
      });

   }

   //===========================================================================
   //                          Component Layout
   //===========================================================================
   private void layoutComponents()
      throws Exception
   {
      this.myDownloadPanel = new DownloadPanel(this);

      // Set up center panel
      JTabbedPane jTabbed = new JTabbedPane();
      jTabbed.addTab(Jibs.getString("Optimizer.8"), this.myWorkingList.getPanel()); //$NON-NLS-1$
      jTabbed.addTab(Jibs.getString("Optimizer.9"), this.myStableList.getPanel()); //$NON-NLS-1$
      jTabbed.addTab(Jibs.getString("Optimizer.10"), this.myDownloadPanel); //$NON-NLS-1$

      // Set up content pane
      JPanel thePanel = new JPanel(new BorderLayout());
      thePanel.add(jTabbed, BorderLayout.CENTER);
      this.setContentPane(new JScrollPane( thePanel ));
   } 


   void exit()
   {
      this.myKiller.kill();
      OptimizerPreferences.flush();
      if (this.iExitOnClose)
      {
         System.exit(0);
      }
      else
      {
         // TODO: May want to kill any running worker thread.
         // Would need to track in here and manage from the actual workers
         // adding an interupt routine to the workers.
         this.setVisible(false);
         dispose();
      }
   }

   //===========================================================================
   //                              Main
   //===========================================================================
   /*
   public static void main(String[] args)
   {
		AppStarter.starupApp(args, "org.gerhardb.jibs.Jibs", true, "Optimizer");
      new Optimizer(true);
   }
   */
}


