/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.jibs.producer;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.*;

import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.ActionHelpers;
import org.gerhardb.lib.util.Icons;

/**
 * A puzzle game with one missing tile.
 * IF YOU EVER FIGURE OUT HOW TO BEAT THE GAME,
 * COMMENT IN THE FINISH BUTTON AND ADD THE LOGIC THERE.
 * 
 * ALSO, THE TEST BUTTON IS COMMENTE OUT.  IT ROTATES THE 
 * EMPTY SQUARE TO TEST VICTORY.
 */
public class JibsPresenter extends JFrame implements IPictureShow
{
   boolean iExitOnClose;
   
   PicturePanel myPicturePanel = new PicturePanel();
   PlayListPlayer myListPlayer = new PlayListPlayer(this);
   JLabel myPictureLabel = new JLabel(" ");
   
   public JibsPresenter(boolean exitOnClose)
   {
      super("JIBS Presenter"); //$NON-NLS-1$
      
      this.iExitOnClose = exitOnClose;
      if (this.iExitOnClose)
      {
         this.addWindowListener(
            new WindowAdapter()
         {
            @Override
				public void windowClosing(WindowEvent evt)
            {
               System.exit(0);
            }
         });
      }
		this.setIconImage(Icons.getIcon(Icons.JIBS_16).getImage());

      layoutComponents();
      
     	JibsPresenter.this.setVisible(true);
      SwingUtils.centerOnScreen(JibsPresenter.this);
   }
   
   //===========================================================================
   //                              IPictureShow Interface
   //===========================================================================
	public void showPicture(BufferedImage image)
	{
		this.myPicturePanel.showPicture(image);
	}
	
	public void showCaption(String caption)
	{
		this.myPictureLabel.setText(caption);
	}
   
   //===========================================================================
   //                             Proctected & Private
   //===========================================================================
   void setPlayList(Play[] playList)
   {
   	this.myListPlayer.setPlayList(playList);
   }
   
   private void layoutComponents()
	{
		// Set up application
		this.setSize(new Dimension(600, 600));

		class CloseAction extends AbstractAction
		{
			CloseAction()
			{
				if (JibsPresenter.this.iExitOnClose)
				{
					super.putValue(Action.NAME, Jibs.getString("MissingTile.19")); //$NON-NLS-1$
					super.putValue(Action.MNEMONIC_KEY, ActionHelpers.getKeyCodeAsInteger("X")); //$NON-NLS-1$
				}
				else
				{
					super.putValue(Action.NAME, Jibs.getString("MissingTile.20"));					 //$NON-NLS-1$
					super.putValue(Action.MNEMONIC_KEY, ActionHelpers.getKeyCodeAsInteger("C")); //$NON-NLS-1$
				}
			}
			
			public void actionPerformed(ActionEvent e)
			{
		      if (JibsPresenter.this.iExitOnClose)
		      {
		      	System.exit(0);
		      }
				else
				{
					JibsPresenter.this.dispose();					
				}
			}
		}
		
		JButton nextBtn = new JButton("Next"); //$NON-NLS-1$
		nextBtn.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent evt)
			{
				JibsPresenter.this.myListPlayer.next();
			}
		});
		
		JButton autoBtn = new JButton("Auto"); //$NON-NLS-1$
		autoBtn.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent evt)
			{
				JibsPresenter.this.myListPlayer.auto();
			}
		});
		
		JButton stopBtn = new JButton("Stop"); //$NON-NLS-1$
		stopBtn.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent evt)
			{
				JibsPresenter.this.myListPlayer.stop();
			}
		});
		
		// "File"
		JMenu fileMenu = new JMenu(Jibs.getString("MissingTile.21")); //$NON-NLS-1$
		fileMenu.setMnemonic('F');
		fileMenu.add(new JMenuItem(new CloseAction()));
		
		JMenuBar menuBar = new JMenuBar();
		menuBar.add(fileMenu);
		this.setJMenuBar(menuBar);		
		
		JPanelRows bottomPanel = new JPanelRows(FlowLayout.CENTER);
		JPanel row = bottomPanel.topRow();
		row.add(this.myPictureLabel);
		
		row = bottomPanel.nextRow();
		row.add(autoBtn);
		row.add(nextBtn);
		row.add(stopBtn);

		this.getContentPane().setLayout(new BorderLayout());
		//this.getContentPane().add(topPanel, BorderLayout.NORTH);
		this.getContentPane().add(this.myPicturePanel, BorderLayout.CENTER);
		this.getContentPane().add(bottomPanel, BorderLayout.SOUTH);
	}
  
   //===========================================================================
   //                              Main
   //===========================================================================
   public static void main(String[] args)
   {
   	PlayFromPipedFormat factory;
		//File playFile = new File("D:/testpics/player/TestPlayList.txt");
		//File picDir = new File( "D:/testpics/player" ); 
		File playFile = new File("D:/dev/workspaces/JIBS/src/test/java/org/gerhardb/jibs/producer/playList-01.xml");
		File picDir = new File( "D:/Kids/" ); 
		
		
		try{ factory = new PlayFromPipedFormat( playFile, picDir ); }
		catch( Exception ex )
		{ 
			System.out.println( ex.getMessage() );
			return;
		}
   	
   	Play[] list = factory.getPlayList();
   	JibsPresenter playerWindow = new JibsPresenter(true);
   	playerWindow.setPlayList(list);
   }
}
