/*
 * Copyright (c) 2008 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.jibs.producer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import org.xml.sax.helpers.DefaultHandler;

public class SaxPlayListParser extends DefaultHandler
{

	List<Play> myPlayList;

	//private String tempVal;

	//to maintain context
	private Play currentPlay;

	SaxPlayListParser()
	{
		this.myPlayList = new ArrayList<Play>();
	}

	private void parseDocument(File file)
	{
		//get a factory
		SAXParserFactory spf = SAXParserFactory.newInstance();
		try
		{
			//get a new instance of parser
			SAXParser sp = spf.newSAXParser();

			//parse the file and also register this class for call backs
			sp.parse(file, this);
		}
		catch (SAXException se)
		{
			se.printStackTrace();
		}
		catch (ParserConfigurationException pce)
		{
			pce.printStackTrace();
		}
		catch (IOException ie)
		{
			ie.printStackTrace();
		}
	}

	/**
	 * Iterate through the list and print
	 * the contents
	 */
	private void printData()
	{

		System.out.println("No of Play Items: '" + this.myPlayList.size() + "'." + "\n");

		Iterator<Play> it = this.myPlayList.iterator();
		while (it.hasNext())
		{
			System.out.println(it.next().toString());
		}
	}


	@Override
	public void startDocument () throws SAXException
	{
		//System.out.println("startDocument");
	}

	/*
	 *Called when the Parser Completes parsing the Current XML File.
	*/
	@Override
	public void endDocument () throws SAXException
	{
		//System.out.println("endDocument");
	}

	/*
	 * In the XML File if the parser encounters a Processing Instruction which is
	 * declared like this  <?ProgramName:BooksLib QUERY="author, isbn, price"?> 
	 * Then this method is called where Target parameter will have
	 * "ProgramName:BooksLib" and data parameter will have  QUERY="author, isbn,
	 *  price". You can invoke a External Program from this Method if required. 
	*/
	@Override
	public void processingInstruction (String target, String data) throws SAXException
	{
		//System.out.println("processingInstruction");
	} 
	
	//Event Handlers
	@Override
	public void startElement(String uri, String localName, String qName,
			Attributes attributes) throws SAXException
	{
		//reset
		if (qName.equalsIgnoreCase("play"))
		{
			//System.out.println("Found Play Start");
			Play play = new Play();
			this.currentPlay = play;
			play.setImageFile(attributes.getValue("image"));
			play.setCaption(attributes.getValue("caption"));
			play.setMinSeconds(attributes.getValue("minTime"));
			this.myPlayList.add(play);
		}
		if (qName.equalsIgnoreCase("audio"))
		{
			//System.out.println("Found Audio Start");
			Audio audio = new Audio();
			audio.setFile(attributes.getValue("file"));
			this.currentPlay.addAudio(audio);
		}
	}

	@Override
	public void characters(char[] ch, int start, int length) throws SAXException
	{
		//String tempVal = new String(ch, start, length);
		//System.out.println("tempVal: " + tempVal);
	}

	@Override
	public void endElement(String uri, String localName, String qName)
			throws SAXException
	{
		//System.out.println("Found Play End");
	}

	public static void main(String[] args)
	{
		try
		{
			File playFile = new File("/dev/workspaces/JIBS/src/test/java/org/gerhardb/jibs6/producer/playList-01.xml");
			if (playFile.exists())
			{
				System.out.println("Found sample file");
			}
			else
			{
				System.out.println("Could not find sample file");				
				System.exit(99);
			}
		
			SaxPlayListParser parser = new SaxPlayListParser();
			parser.parseDocument(playFile);
			System.out.println("=======================");
			parser.printData();
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}
	}

}
