package org.gerhardb.jibs.textCompare;

/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;

import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

import org.gerhardb.lib.io.DirListController;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;

/**
 * User interface for Text Compare.
 * Looks for closely related text files to see if you can dedup them.
 * For example, where you get the same message, but in a different wrapper.
 */
public class TextCompareGUI
   extends JFrame
{
	public static String APP_NAME = "TextCompare";
  	private static Preferences clsPrefs = Preferences.userRoot().node("/org/gerhardb/jibs/textCompare"); //$NON-NLS-1$

  	boolean iExitOnClose;
   DirListController myWorkingList;
   
   //===========================================================================
   //                          Constructor
   //===========================================================================

   public TextCompareGUI(boolean exitOnClose)
   {
      this.iExitOnClose = exitOnClose;
      setTitle("Text Compare");

      addWindowListener(
         new WindowAdapter()
      {
         @Override
			public void windowClosing(WindowEvent e)
         {
            exit();
         }
      }
      );

      enableEvents(AWTEvent.WINDOW_EVENT_MASK);
      try
      {
          layoutComponents();
      }
      catch (Exception e)
      {
         e.printStackTrace();
         System.out.println("*** Unkonwn abnormal termination ***");  //$NON-NLS-1$
         System.exit(99);
      }

		this.setIconImage(Icons.getIcon(Icons.JIBS_16).getImage());
      
      // Work on showing the frame!
      EventQueue.invokeLater(new Runnable()
      {
         public void run()
         {
            TextCompareGUI.this.validate();
            TextCompareGUI.this.pack();
            SwingUtils.centerOnScreen(TextCompareGUI.this);
            TextCompareGUI.this.setVisible(true);
         }
      });

      //myWorkingList.add(new java.io.File("C:/dev/testText"));
   }

   //===========================================================================
   //                          Component Layout
   //===========================================================================
   private void layoutComponents()
      throws Exception
   {
     DirListController.Clearable clearablePanel = new TextComparePanel(this);
     this.myWorkingList =
   	      new DirListController(clearablePanel, "Text Compare", "TextCompare", false, APP_NAME); //$NON-NLS-1$ //$NON-NLS-2$

      // Set up center panel
      JTabbedPane jTabbed = new JTabbedPane();
      jTabbed.addTab("Directories", this.myWorkingList.getPanel()); //$NON-NLS-1$
      jTabbed.addTab("Compare", new TextComparePanel(this)); //$NON-NLS-1$

      // Set up content pane
      JPanel thePanel = new JPanel(new BorderLayout());
      thePanel.add(jTabbed, BorderLayout.CENTER);
      this.setContentPane(new JScrollPane( thePanel ));
   } 


   void exit()
   {
   	try{clsPrefs.flush();}
   	catch(Exception ex)
   	{
   		ex.printStackTrace();
   	}
      if (this.iExitOnClose)
      {
         System.exit(0);
      }
      else
      {
         // TODO: May want to kill any running worker thread.
         // Would need to track in here and manage from the actual workers
         // adding an interupt reutine to the workers.
         this.setVisible(false);
         dispose();
      }
   }

   //===========================================================================
   //                              Main
   //===========================================================================
   public static void main(String[] args)
   {
      new TextCompareGUI(true);
   }
}
