/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.jibs.textCompare;

import java.io.File;
import javax.swing.*;

/**
 * User interface for the Camera.
 */
public class TextCompareListItem extends JLabel
{
	String myLeftFileAbsolutePath;
	String myRightFileAbsolutePath;

   //===========================================================================
   //                          Constructor
   //===========================================================================

   public TextCompareListItem(String leftFileAbsolutePath, String rightFileAbsolutePath)
   {
   	this.myLeftFileAbsolutePath = leftFileAbsolutePath;
   	this.myRightFileAbsolutePath = rightFileAbsolutePath;
   }

   public TextCompareListItem(File left, File right)
   {
   	this.myLeftFileAbsolutePath = left.getAbsolutePath();
   	this.myRightFileAbsolutePath = right.getAbsolutePath();
   }
   
   public File getRightFile()
   {
   	return new File(this.myRightFileAbsolutePath);
   }
   
   public File getLeftFile()
   {
   	return new File(this.myLeftFileAbsolutePath);
   }   
   
   boolean autoRemoved(File[] autoDirs)
   {
   	File leftParent = new File(new File(this.myLeftFileAbsolutePath).getParent());
   	File rightParent = new File(new File(this.myRightFileAbsolutePath).getParent());
   	System.out.println("---------------------------------------------------");
   	System.out.println("leftParent: " + leftParent);
   	System.out.println("rightParent: " + rightParent);
   	for(int i=0; i<autoDirs.length; i++)
   	{
      	System.out.println("autoDirs: " + autoDirs[i]);
      	try
      	{
	   		if (autoDirs[i].equals(leftParent))
	   		{
	   				System.out.println("AUTO DELETING: " + this.myLeftFileAbsolutePath);
	    				if (new File(this.myLeftFileAbsolutePath).delete())
	   				{
	   					return true;
	   				}
	   		}
	   		if (autoDirs[i].equals(rightParent))
	   		{
	   				System.out.println("AUTO DELETING: " + this.myRightFileAbsolutePath);
	    				if (new File(this.myRightFileAbsolutePath).delete())
	   				{
	   					return true;
	   				}
	   		}
      	}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
   	}
   	return false;
   }
   
   @Override
	public String toString()
   {
   	return "<html>." + this.myLeftFileAbsolutePath + "<br>......." + this.myRightFileAbsolutePath + "</html>";
   }
}
