/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.jibs.textCompare;

import java.awt.*;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.*;

import org.gerhardb.lib.io.FileUtil;
import org.gerhardb.lib.swing.JPanelRows;

/**
 * Displable text file which can be deleted.
 */
public class TextFilePanel extends JPanelRows
{
	TextComparePanel myParent;
	private JTextArea myTextArea = new JTextArea(" ");
	private JLabel myFileName = new JLabel("none");
	File myFile;
	private JButton myDeleteBtn = new JButton("Delete");

   //===========================================================================
   //                          Constructor
   //===========================================================================

   public TextFilePanel(TextComparePanel parent)
   {
   	this.myParent = parent;
      clear();
      
      this.myDeleteBtn.addActionListener(new ActionListener()
      {
         public void actionPerformed(java.awt.event.ActionEvent evt)
         {
         	TextFilePanel.this.myParent.delete(TextFilePanel.this.myFile);
         }
      });
      
      this.myTextArea.setLineWrap(false);
      this.myTextArea.setWrapStyleWord(true);
      this.myTextArea.setEditable(false);
      this.myTextArea.setRows(5);
      this.myTextArea.setColumns(20);
      
      JPanel aRow = this.topRow(new BorderLayout());
      aRow.add(new JScrollPane(this.myTextArea), BorderLayout.CENTER);

      aRow = this.nextRow();
      aRow.add(new JLabel("File: "));
      aRow.add(this.myFileName);
      
      aRow = this.nextRow(new BorderLayout());
      aRow.add(this.myDeleteBtn, BorderLayout.SOUTH);
   }
   
	JButton getDeleteButton(){return this.myDeleteBtn;}  
	
	JScrollPane getTextArea()
	{	
		JScrollPane rtnMe = new JScrollPane(this.myTextArea);
		rtnMe.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
		rtnMe.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
		return rtnMe;
	}
	
	JPanel getFilePanel()
	{
		JPanel rtnMe = new JPanel(new FlowLayout(FlowLayout.LEFT));
		rtnMe.add(new JLabel("File: "));
		rtnMe.add(this.myFileName);
		return rtnMe;
	} 
   
   void setFile(File file)
   {
   	if (file != null && file.exists())
   	{
   		this.myFile = file;
   		this.myFileName.setText(this.myFile.getAbsolutePath());
   		this.myDeleteBtn.setEnabled(true);
   		try
   		{
	         String text = FileUtil.getStringFromFile(this.myFile);
	         this.myTextArea.setText(text);
	         this.myTextArea.setCaretPosition(0);
   		}
   		catch(Exception ex)
   		{
            JOptionPane.showMessageDialog(
               	TextFilePanel.this,
                  ex.getMessage(),
                  this.myFile.getAbsolutePath(),
                  JOptionPane.ERROR_MESSAGE);
               ex.printStackTrace();   			
   		}
   	}
   }

	void clear()
	{
		this.myDeleteBtn.setEnabled(false); 
		this.myTextArea.setText("");
		this.myFileName.setText("");
	}
}
