/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.jibs.textPad;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.dirtree.rdp.StatusBarManager.AutocopyFilenamePanel;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;

/**
 *
 * @author  Gerhard Beck
 */
public class TextPadOptionsDialog
   extends javax.swing.JDialog
{
   TextPad myTextPad;
   TreePanel myTreePanel;
   AutocopyFilenamePanel myAutocopyFilenamePanel;

   //===========================================================================
   //                              Constructor
   //===========================================================================
   public TextPadOptionsDialog(TextPad owner)
   {
      super(owner, Jibs.getString("ViewerPreferencesDialog.12"), true); //$NON-NLS-1$
      this.myTextPad = owner;
      
      this.myAutocopyFilenamePanel = this.myTextPad.myLST.getStatusBarManager().getAutocopyFilenamePanel();
      JPanel aRow = this.myAutocopyFilenamePanel.nextRow();      
      aRow.add(this.myTextPad.getLST().getBasicOptionsManager().getStartupComponent(null));
      aRow.add(this.myTextPad.getLST().getBasicOptionsManager().getSortComponent());
      this.myTextPad.getLST().getBasicOptionsManager().adjustView();
       
      JTabbedPane jTabbed = new JTabbedPane();
      jTabbed.addTab("Basic", this.myAutocopyFilenamePanel);  
      jTabbed.addTab(Jibs.getString("ViewerPreferencesDialog.15"), this.myTextPad.myLST.getPathManager().directoryPanel()); //$NON-NLS-1$

      // Set up content pane
      JPanel thePanel = new JPanel(new BorderLayout());
      thePanel.add(jTabbed, BorderLayout.CENTER);
      thePanel.add(getOkCancelPanel(), BorderLayout.SOUTH);
      this.setContentPane(thePanel);     
      
      this.pack();

      // Add these later to make sure it does not increase the size.
      this.myTreePanel = new TreePanel();
      jTabbed.addTab(Jibs.getString("ViewerPreferencesDialog.11"), this.myTreePanel);  //$NON-NLS-1$
      
      SwingUtils.centerOnScreen(this);
      this.setVisible(true);
   }

   void save()
   {
   	this.myTextPad.myLST.getPathManager().save();
   	this.myTextPad.getLST().getBasicOptionsManager().save();
      this.myAutocopyFilenamePanel.save();
      // Do tree panel last in case user bails during reload of nodes.
      this.myTreePanel.save();
      try{TextPad.clsPrefs.flush();}catch(Exception ex){ex.printStackTrace();}
   	super.setVisible(false);
      super.dispose();   	
      this.myTextPad.repaint();
   }
   
   void cancel()
   {
   	super.setVisible(false);
      super.dispose();   	
   }
   
  	private JPanel getOkCancelPanel()
	{
      JButton btnSave = new JButton(Jibs.getString("save")); //$NON-NLS-1$
      btnSave.addActionListener(
         new java.awt.event.ActionListener()
      {
         public void actionPerformed(java.awt.event.ActionEvent evt)
         {
         	TextPadOptionsDialog.this.save();
         }
      });

      JButton btnCancel = new JButton(Jibs.getString("cancel")); //$NON-NLS-1$
      btnCancel.addActionListener(
         new java.awt.event.ActionListener()
      {
         public void actionPerformed(java.awt.event.ActionEvent evt)
         {
         	TextPadOptionsDialog.this.cancel();
         }
      });

      JPanel okPanel = new JPanel();
      okPanel.add(btnSave);
      okPanel.add(btnCancel);
      return okPanel;
   }

   //===========================================================================
   //                          Tree Panel
   //===========================================================================

   class TreePanel extends JPanelRows
   {
      JCheckBox myCountTextFilesBox = new JCheckBox(
      		"Separately count text files in directory tree (results in slower loads and moves)"); 
      boolean priorCountTarget = TextPadOptionsDialog.this.myTextPad.getCountTargetFiles();
      
		TreePanel()
   	{    
	      this.myCountTextFilesBox.setSelected(TextPadOptionsDialog.this.myTextPad.getCountTargetFiles());	      
	      this.myCountTextFilesBox.addActionListener
         (
            new ActionListener()
            {
               public void actionPerformed(ActionEvent ae)
               {
               	// First pass - make sure user wants to do this
               	if (TreePanel.this.myCountTextFilesBox.isSelected())
               	{
             			// Only warn if a change was made.
            			if (TextPadOptionsDialog.this.myTextPad.getCountTargetFiles() != true)
            			{           			
	              			  int picked = JOptionPane.showConfirmDialog(TreePanel.this,
	              					"This save will take considerable time\nbecause the directory tree has to\nrecount all the files.",  
	              					"Note", JOptionPane.OK_CANCEL_OPTION); 
	            	    	  if (picked == JOptionPane.CANCEL_OPTION)
	            	    	  {
	            	    		  // Turn check box off.  
	            	    		  TreePanel.this.myCountTextFilesBox.setSelected(false);
	            	    	  }      		
            			}
               	}
               }
            }
         );
	      
	      JPanel aRow = super.topRow();
	      aRow.add(this.myCountTextFilesBox);
   	}
   	
		void save()
		{
	      TextPad.clsPrefs.putBoolean(TextPad.COUNT_TEXT_FILES, this.myCountTextFilesBox.isSelected());
	      try{TextPad.clsPrefs.flush();}catch(Exception ex){ex.printStackTrace();}
			if (this.priorCountTarget != this.myCountTextFilesBox.isSelected())
			{
				TextPadOptionsDialog.this.myTextPad.myLST.getTree().setCountTargetFiles(this.myCountTextFilesBox.isSelected());
				TextPadOptionsDialog.this.myTextPad.myLST.getTreeManager().reloadAllNodes();
			}
		}
   }
   
   //===========================================================================
   //                          Other Panel
   //===========================================================================

   /*
   class ShowTextPanel extends JPanelRows
   {
       JCheckBox myShowText = new JCheckBox("Show text files"); 
      
       ShowTextPanel()
   	{
      	myShowText.setSelected(ImageFactory.getImageFactory().isTextFilesShowingPreferenceSet());
	      
	      //JPanel aRow = super.topRow();
		      
	      // **ShowText** Attempt
	      //aRow = super.nextRow();
	      //aRow.add(myShowText);
   	}
   	
		void save()
		{
      	// Update preferences and then make sure they show up.
      	ImageFactory.getImageFactory().setTextFilesShowingPreference(myShowText.isSelected());   
   		myTextPad.myLST.getScroller().reloadScroller();   	
		}
   }
*/
 }





