/*
 * Copyright (c) 2010 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.jibs.textPad.ranker;

import java.awt.BorderLayout;
import java.awt.event.*;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;

/**
 * Info Display.
 */
public class AppRanker extends JFrame
{
	private boolean iExitOnClose;
	private CountAndRankPanel myCountAndRankUI = new CountAndRankPanel();
	//private WordCountUI myWordCountUI = new WordCountUI();	
	//private RankUI myRankUI = new RankUI();

	/*
	 * =========================================================================
	 *                         Constructor
	 * =========================================================================
	 */

	/**
	 * Counts Words
	 */
	public AppRanker(boolean exitOnClose)
	{
		this.iExitOnClose = exitOnClose;
		addWindowListener(new WindowAdapter()
		{
			@Override
			public void windowClosing(WindowEvent e)
			{
				exit();
			}
		});

		this.setIconImage(Icons.getIcon(Icons.JIBS_16).getImage());
		setTitle("JIBS Text: Count Words & Rank Files"); 
		this.setJMenuBar(this.makeMenus()); 

	     // Set up center panel
      JTabbedPane jTabbed = new JTabbedPane();      
      jTabbed.addTab("Count & Rank", this.myCountAndRankUI);
      //jTabbed.addTab("Count Words", myWordCountUI); 
      //jTabbed.addTab("Score Files", new JScrollPane(myRankUI)); 

      // Set up content pane
      JPanel thePanel = new JPanel(new BorderLayout());
      thePanel.add(jTabbed, BorderLayout.CENTER);
      this.setContentPane(thePanel);

      pack();
      SwingUtils.centerOnScreen(this);
		super.setVisible(true);
	}
	
	void exit()
	{
		//myWordCountUI.exit();
		//myRankUI.exit();
		this.myCountAndRankUI.exit();

		if (this.iExitOnClose)
		{
			System.exit(0);
		}
		else
		{
			// TODO: May want to kill any running worker thread.
			// Would need to track in here and manage from the actual workers
			// adding an interupt reutine to the workers.
			this.setVisible(false);
			dispose();
		}
	}

	JMenuBar makeMenus()
	{
		JMenu fileMenu = new JMenu("File"); 

		JMenuItem closeMenu = new JMenuItem("Close");
		if (this.iExitOnClose)
		{
			closeMenu.setText("Exit");
		}
		
		closeMenu.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				exit();
				AppRanker.this.dispose();
			}
		});

		//fileMenu.add(openMenu);
		//fileMenu.add(new JSeparator());
		fileMenu.add(closeMenu);

		JMenuBar menuBar = new JMenuBar();
		menuBar.add(fileMenu);
		//menuBar.add( Box.createHorizontalGlue() );
		//menuBar.add( helpMenu );

		return menuBar;
	}
	
	// ==========================================================================
	// Main
	// ==========================================================================
	public static void main(String[] args)
	{
		new AppRanker(true);
	}
}
