/*
 * Copyright (c) 2010 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.jibs.textPad.ranker;

class ScoreForCount implements Comparable<ScoreForCount>
{
	int myCount = 0;
	int myScore = 0;

	ScoreForCount(String scoreToken) throws Exception
	{
		String[] split = scoreToken.split("->");
		if (split.length > 0)
		{
			try
			{
				this.myCount = Integer.parseInt(split[0].trim());
			}
			catch (Exception ex)
			{
				throw new Exception("Cound not get count from: "
						+ scoreToken.trim() + ": " + ex.getMessage());
			}
		}
		if (split.length > 1)
		{
			try
			{
				this.myScore = Integer.parseInt(split[1].trim());
			}
			catch (Exception ex)
			{
				throw new Exception("Cound not get score from: "
						+ scoreToken.trim() + ": " + ex.getMessage());
			}
		}
		if (split.length > 2)
		{
			RankByWordCounts.logln("More than one > found:" + scoreToken);
		}
	}

	public int compareTo(ScoreForCount other)
	{
		if (other.myCount > this.myCount)
		{
			return 1;
		}
		else if (other.myCount < this.myCount) { return -1; }
		return 0;
	}

	@Override
	public String toString()
	{
		return this.myCount + "->" + this.myScore;
	}
}
