/*
 * Copyright (c) 2010 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.jibs.textPad.ranker;

import java.io.File;

class ScoringFileName
{
	String[] myScoringWordsOrGroups; // sub,submarine		
	int myScore;

	ScoringFileName(String aLine)
			throws Exception
	{
		RankByWordCounts.logln("Name Input:  " + aLine);

		// Remove the @ at the front.
		aLine = aLine.substring(1);

		String[] tokens = aLine.split(":");
		if (tokens.length != 2) { throw new Exception(
				"This line is not formated for a @ file name score:" + aLine); }

		String words = null;
		String score = null;
		if (tokens.length == 2)
		{
			words = tokens[0].trim();
			score = tokens[1].trim();
		}

		if (words == null || words.length() == 0) { throw new Exception(
				"No words found in:" + aLine); }

		this.myScoringWordsOrGroups = words.split(",");

		for (int i = 0; i < this.myScoringWordsOrGroups.length; i++)
		{
			this.myScoringWordsOrGroups[i] = this.myScoringWordsOrGroups[i].trim();
		}

		if (score == null || score.length() == 0) { throw new Exception(
				"No scores found in:" + aLine); }

		try
		{
			this.myScore = Integer.parseInt(score);
		}
		catch (Exception ex)
		{
			throw new Exception("Score not a number in:" + aLine);
		}
		RankByWordCounts.logln("Output: " + this);
	}

	int score(String filePath)
	{
		if (filePath == null || filePath.length() < 1) { return 0; }
		String name = new File(filePath).getName();
		for (String word : this.myScoringWordsOrGroups)
		{
			if (name.contains(word)) { return this.myScore; }
		}
		return 0;
	}
}
