/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.gerhardb.jibs.util;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.prefs.Preferences;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.swing.JFileChooserExtra;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;
import org.gerhardb.lib.util.Icons;

/*
 * REMOVED com.twmacinta.util.MD5 BECAUSE THE LIBRARY IN QUESTION 
 * HAS OPERATING SYSTEM DEPENDENT FILES...
 * Got Java code from http://www.twmacinta.com/myjava/fast_md5.php, 
 * but did not use the faster way there coded.
 */

//import com.twmacinta.util.MD5;

/**
 * REMOVED BECAUSE THE LIBRARY IN QUESTION HAS OPERATING SYSTEM DEPENDENT FILES...
 * Added a hash check sum checker because I could not easily find one and I hate looking.
	FireFox plug-in is in test status and I didn't feel like registering.
	Got Java code from http://www.twmacinta.com/myjava/fast_md5.php, but did not use
	the faster way there coded, just the old fashioned way shown.  Did use the hex converter...

 */

public class CheckSumChecker extends JFrame
{
	private static final String LAST_FILE = "LastFile";
	private static final String ALGORITHM = "Algorithm";

	private static final Preferences clsPrefs = Preferences.userRoot().node("/org/gerhardb/jibs/util/CheckSumChecker");

	JTextField myFileName = new JTextField(60);
	JTextField myDownloadedHash = new JTextField(60);
	JLabel myComputedHash = new JLabel("     ");
	JLabel myResults = new JLabel("     ");
	JComboBox myAlgorithm = new JComboBox();

	private static final char[] HEX_CHARS = { '0', '1', '2', '3', '4', '5', '6',
			'7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', };

	public CheckSumChecker()
	{
		super("Check Sum Checker");

		layoutComponents();
		this.myFileName.setText(clsPrefs.get(LAST_FILE, null));

		this.setIconImage(Icons.getIcon(Icons.JIBS_16).getImage());

		EventQueue.invokeLater(new Runnable()
		{
			public void run()
			{
				CheckSumChecker.this.pack();
				CheckSumChecker.this.setVisible(true);
				SwingUtils.centerOnScreen(CheckSumChecker.this);
			}
		});
	}

	private void layoutComponents()
	{
		// Set up application
		this.setSize(new Dimension(600, 600));

		this.myAlgorithm.addItem("MD2");
		this.myAlgorithm.addItem("MD5");
		this.myAlgorithm.addItem("SHA-1");
		this.myAlgorithm.addItem("SHA-256");
		this.myAlgorithm.addItem("SHA-384");
		this.myAlgorithm.addItem("SHA-512");
		this.myAlgorithm.setEditable(false);
		this.myAlgorithm.setSelectedItem(clsPrefs.get(ALGORITHM, "MD2"));

		JButton goBtn = new JButton("Compute Hash");
		goBtn.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent evt)
			{
				go();
			}
		});

		JButton fileBtn = new JButton("...");
		fileBtn.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent evt)
			{
				selectFile();
			}
		});

		JButton compareBtn = new JButton("Compare");
		compareBtn.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent evt)
			{
				checkHashes();
			}
		});

		JPanelRows topPanel = new JPanelRows(FlowLayout.CENTER);
		JPanel aRow = topPanel.topRow();
		aRow.add(new JLabel("File: "));
		aRow.add(this.myFileName);
		aRow.add(fileBtn);

		aRow = topPanel.nextRow();
		aRow.add(this.myAlgorithm);
		aRow.add(goBtn);

		aRow = topPanel.nextRow();
		aRow.add(this.myComputedHash);

		aRow = topPanel.nextRow();
		aRow.add(new JLabel("Hash to compare: "));
		aRow.add(this.myDownloadedHash);

		aRow = topPanel.nextRow();
		aRow.add(compareBtn);

		aRow = topPanel.nextRow();
		aRow.add(this.myResults);
		this.setContentPane(topPanel);
	}

	void selectFile()
	{
		JFileChooserExtra chooser = new JFileChooserExtra(clsPrefs.get(LAST_FILE,
				null));
		chooser.setDialogTitle(Jibs.getString("CheckSumChecker.15"));
		chooser.setFileSelectionMode(JFileChooser.FILES_ONLY);
		chooser.setMultiSelectionEnabled(false);
		chooser.setSaveName("CheckSumChecker", "DirectoryTreeList.txt");

		int returnVal = chooser.showOpenDialog(this);
		if (returnVal == JFileChooser.APPROVE_OPTION)
		{
			File picked = chooser.getSelectedFile();
			if (picked != null)
			{
				String fileName = picked.toString();
				if (!fileName.contains("."))
				{
					fileName = fileName + ".txt";
				}
				this.myFileName.setText(fileName);
				try
				{
					clsPrefs.put(LAST_FILE, picked.toString());
					clsPrefs.flush();
				}
				catch (Exception ex)
				{
					ex.printStackTrace();
				}
			}
		}
	}

	void go()
	{
		String algorithm = this.myAlgorithm.getSelectedItem().toString();
		clsPrefs.put(ALGORITHM, this.myAlgorithm.getSelectedItem().toString());
		String fileName = this.myFileName.getText();
		//System.out.println("CheckSumChecker Selected File: " + fileName);
		File fileToHash = new File(fileName);
		if (!fileToHash.exists())
		{
			JOptionPane.showMessageDialog(this, "Could not access file",
					"Problem", JOptionPane.ERROR_MESSAGE);
			return;
		}

		this.myResults.setOpaque(false);

		setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		try
		{
			MessageDigest md = MessageDigest.getInstance(algorithm);
			int totalBytesRead = 0;

			// Create the byte array to hold the data
			byte[] input = new byte[1000000];

			InputStream is = new FileInputStream(fileToHash);
			int bytesRead = is.read(input);
			if (bytesRead < input.length)
			{
				// Edge case where we don't go through loop at least once.
				totalBytesRead = +bytesRead;
			}
			else
			{
				// Edge case for first time through.
				totalBytesRead = totalBytesRead + bytesRead;				
			}
			while (bytesRead == input.length)
			{
				md.update(input);
				bytesRead = is.read(input);
				totalBytesRead = totalBytesRead + bytesRead;
			}
			byte[] finalInput = new byte[bytesRead];
			for (int i = 0; i < bytesRead; i++)
			{
				finalInput[i] = input[i];
			}
			md.update(finalInput);

			// Close the input stream and return bytes
			is.close();

			System.out.println("fileToHash.length(): " + fileToHash.length());

			System.out.println("totalBytesRead:      " + totalBytesRead);

			if (fileToHash.length() != totalBytesRead)
			{
				JOptionPane.showMessageDialog(this, "Could not read entire file",
						"Problem Encountered", JOptionPane.ERROR_MESSAGE);
				return;

			}
			byte[] theHashAsBytes = md.digest();
			String hexHash = asHex(theHashAsBytes);
			//System.out.println("GB:  "  + hexHash);
			//String hash = MD5.asHex(MD5.getHash(fileToHash));
			//System.out.println("MD5: "  + hash);
			this.myComputedHash.setText(hexHash);
		}
		catch (Exception ex)
		{
			JOptionPane.showMessageDialog(this, ex.getMessage(),
					"Problem Encountered", JOptionPane.ERROR_MESSAGE);
			return;
		}

		if (this.myDownloadedHash.getText().trim().length() > 0)
		{
			checkHashes();
		}
		setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
	}

	void checkHashes()
	{
		String computedHash = this.myComputedHash.getText().trim();
		this.myResults.setOpaque(true);
		// Always returns a string.
		if (computedHash.length() == 0)
		{
			go();
			computedHash = this.myComputedHash.getText().trim();
			if (computedHash.length() == 0)
			{
				this.myResults.setText("You need to compute a hash on a file first.");
				this.myResults.setBackground(Color.YELLOW);
				return;
			}
		}

		String downloadedHash = this.myDownloadedHash.getText();
		// Always returns a string.
		downloadedHash = downloadedHash.trim();
		if (downloadedHash.length() == 0)
		{
			this.myResults.setText("You need to enter a hash to compare against.");
			this.myResults.setBackground(Color.YELLOW);
			return;
		}

		if (computedHash.equals(downloadedHash))
		{
			this.myResults.setText("The hashes match.");
			this.myResults.setBackground(Color.GREEN);
		}
		else
		{
			this.myResults.setText("The hashes do not match.");
			//myResults.setForeground(Color.RED);
			this.myResults.setBackground(Color.RED);
		}
	}

	/**
	* Turns array of bytes into string representing each byte as
	* unsigned hex number.
	* 
	* Originally from: http://www.twmacinta.com/myjava/fast_md5.php
	* 
	* @param hash Array of bytes to convert to hex-string
	* @return Generated hex string
	*/
	public static String asHex(byte hash[])
	{
		char buf[] = new char[hash.length * 2];
		for (int i = 0, x = 0; i < hash.length; i++)
		{
			buf[x++] = HEX_CHARS[(hash[i] >>> 4) & 0xf];
			buf[x++] = HEX_CHARS[hash[i] & 0xf];
		}
		return new String(buf);
	}

	// ===========================================================================
	// Main
	// ===========================================================================
	public static void main(String[] args)
	{
		new CheckSumChecker();
	}
}

// Add one for backslash.
// If myCurrentDirName == C:\gbroot\DCGS-N
// you need to strip for C:\gbroot\DCGS-N\

