/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.jibs.viewer;

import java.io.File;

import javax.swing.JComponent;
import javax.swing.JMenuItem;

import org.gerhardb.lib.scroller.ScrollerListener;
import org.gerhardb.lib.util.Range;
import org.gerhardb.lib.util.app.InfoPlugins;

/**
 * This is the panel to actually show the picture or thumbnails or whatever.
 * Usually in the middle of the three part screen with a list on the left and a
 * tree on the right.
 * 
 * @author Gerhard Beck
 */
public interface IShow extends ScrollerListener, InfoPlugins
{
	public JComponent getImageDisplay();
	public void jumpTo(File file);
	public void reloadScroller();
	public void reloadScroller(int index, boolean reloadCahce);
	public void resetFocus();
	public void showImage();
	public void showPageFromScroller();
	public void startSlideShow();
	public void connect();
	public void disconnect();
	public JMenuItem makePreferencesItem();
	public Range showingIndexes();
	public ISave getSaver();
	public void swapPictureFocus();
}