/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.jibs.viewer;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JButton;
import javax.swing.JComponent;

import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.scroller.Scroller;
import org.gerhardb.lib.util.Icons;

/**
 *
 * @author  Gerhard Beck
 */
public class PicInfoDialog
   extends PicInfoDialogBase
{
   IRevert myRevert;
   JButton myDeleteBtn;
   JButton myParkBtn;

   //===========================================================================
   //                              Constructor
   //===========================================================================
   public PicInfoDialog(
   	File file,
      Frame owner,
      JComponent picturePanel,  // may be null
      IRevert revert,
      JButton deleteBtn, 
      JButton parkBtn, 
      boolean fullScreen,
      int displayInfoWidth,
      int displayInfoHeight,
      boolean showDisplayInfo, 
      Scroller scroller)
   {
      super(owner, scroller); 

   	this.myRevert = revert;
      this.myDeleteBtn = deleteBtn;
      this.myParkBtn = parkBtn;


   	System.out.println("PicInfoDialog a");
   	super.display(file, picturePanel, displayInfoWidth, displayInfoHeight, showDisplayInfo); 
   	System.out.println("PicInfoDialog b");

      if (fullScreen)
      {
      	System.out.println("PicInfoDialog c");
         try
         {
            Dimension screenSize = this.getToolkit().getScreenSize();
            int x = screenSize.width / 2;
            int y = screenSize.height / 2;

            GraphicsEnvironment ge =
               GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice gd = ge.getDefaultScreenDevice();
            Robot rob = new Robot(gd);
            rob.mouseMove(x, y);
         }
         catch (Exception ex)
         {
            ex.printStackTrace();
         }
      }     
   }

   @Override
	protected JButton[] getToolBarButtons()
   {  	
      JButton slideShowBtn = new JButton();
      if (this.isSlideShowRunning)
      {
         slideShowBtn.setIcon(Icons.getIcon(Icons.STOP_MOVIE));
         slideShowBtn.setToolTipText(Jibs.getString("PicInfoDialog.6")); //$NON-NLS-1$
      }
      else
      {
         slideShowBtn.setIcon(Icons.getIcon(Icons.MOVIE));
         slideShowBtn.setToolTipText(Jibs.getString("PicInfoDialog.7")); //$NON-NLS-1$
      }
      slideShowBtn.addActionListener(
         new ActionListener()
      {
         public void actionPerformed(ActionEvent event)
         {
            PicInfoDialog.this.isSlideShowRunning = !PicInfoDialog.this.isSlideShowRunning;
            close();
         }
      });

      JButton revertBtn = new JButton();
      if (this.myRevert.isFullScreen())
      {
         revertBtn.setIcon(Icons.getIcon(Icons.BASIC_SCREEN));
         revertBtn.setToolTipText(Jibs.getString("PicInfoDialog.8")); //$NON-NLS-1$
      }
      else
      {
         revertBtn.setIcon(Icons.getIcon(Icons.FULL_SCREEN));
         revertBtn.setToolTipText(Jibs.getString("PicInfoDialog.9")); //$NON-NLS-1$
      }
      
      revertBtn.addActionListener(
         new ActionListener()
      {
         public void actionPerformed(ActionEvent event)
         {
            PicInfoDialog.this.isSlideShowRunning = false;
            close();
            PicInfoDialog.this.myRevert.revert();
         }
      });

       this.myDeleteBtn.addActionListener(
         new ActionListener()
      {
         public void actionPerformed(ActionEvent event)
         {
            close();
         }
      });

      this.myParkBtn.addActionListener(
         new ActionListener()
      {
         public void actionPerformed(ActionEvent event)
         {
             close();
         }
      });
      
      JButton[] rtnMe = {revertBtn, this.myDeleteBtn, this.myParkBtn, slideShowBtn};
      return rtnMe;
   }
}
