/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.jibs.viewer;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.image.BufferedImage;
import java.io.File;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.scroller.Scroller;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.image.ImageChangeUtil;
import org.gerhardb.lib.image.ImageFactory;
import org.gerhardb.lib.image.ImageUtilDrew;
import org.gerhardb.lib.io.FileUtil;

/**
 *
 * @author  Gerhard Beck
 */
public class PicInfoExif
{
   private File myFile;
   private JComponent myPicturePanel;
   private int myShownWidth;
   private int myShownHeight;
   private boolean iShowDisplayInfo = false;   
   private JPanelRows myPicInfoRows = new JPanelRows();
	Scroller myScroller;

   public PicInfoExif(
      	File file,
         JComponent picturePanel, // may be null
         int displayInfoWidth,
         int displayInfoHeight,
         boolean showDisplayInfo, 
         Scroller scroller)
   {
      this.myFile = file;
      this.myPicturePanel = picturePanel;
      this.myShownWidth = displayInfoWidth;
      this.myShownHeight = displayInfoHeight;
      this.iShowDisplayInfo = showDisplayInfo;
      this.myScroller = scroller;
   }
   
   public JPanel makeBorderPanel()
   {
      JPanel aRow = this.myPicInfoRows.topRow(FlowLayout.CENTER);
		try
		{
			BufferedImage image = ImageFactory.getImageFactory().makeImage(this.myFile).getImage();
			BufferedImage sized = ImageChangeUtil.fitAspectDown(image, 100, 100);
			ImageIcon imageIcon = new ImageIcon(sized);
			JLabel picture = new JLabel(imageIcon);
			picture.setSize(100, 100);
			Border raisedbevel = BorderFactory.createRaisedBevelBorder();
			Border loweredbevel = BorderFactory.createLoweredBevelBorder();
			Border compound = BorderFactory.createCompoundBorder(raisedbevel,
					loweredbevel);
			picture.setBorder(compound);
		   aRow.add(picture);
		   aRow = this.myPicInfoRows.nextRow(FlowLayout.CENTER);
	      aRow.add(new JLabel(this.myFile.getAbsolutePath())); 
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
	      aRow.add(new JLabel(Jibs.getString("PicInfoDialog.10") + Jibs.getString("colon") + " " + this.myFile.getAbsolutePath())); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$    
		}     

    	ImageUtilDrew drew = new ImageUtilDrew(this.myFile);
      if (drew.parsableFileType()) //$NON-NLS-1$ //$NON-NLS-2$
      {
          try
         {
            showExifTag(drew, Jibs.getString("date"), ImageUtilDrew.TAG_DATETIME); //$NON-NLS-1$
            showExifTag(drew, Jibs.getString("PicInfoDialog.14"), ImageUtilDrew.TAG_DATETIME_ORIGINAL); //$NON-NLS-1$
            //showExifTag(drew, Jibs.getString("PicInfoDialog.15"), ImageUtilDrew.TAG_DATETIME_DIGITIZED); //$NON-NLS-1$
            showExifTag(drew, Jibs.getString("PicInfoDialog.16"), ImageUtilDrew.TAG_MAKE); //$NON-NLS-1$
            showExifTag(drew, Jibs.getString("PicInfoDialog.17"), ImageUtilDrew.TAG_MODEL); //$NON-NLS-1$
         }
         catch (Exception ex)
         {
            aRow = this.myPicInfoRows.nextRow();
            aRow.add(new JLabel(Jibs.getString("PicInfoDialog.18"))); //$NON-NLS-1$
            ex.printStackTrace();
         }
      }
      else
      {
         aRow = this.myPicInfoRows.nextRow();
         aRow.add(new JLabel(Jibs.getString("PicInfoDialog.19"))); //$NON-NLS-1$
      }
      
      aRow = this.myPicInfoRows.nextRow();
      aRow.add(new JLabel("File size: " + FileUtil.getSize(this.myFile))); //$NON-NLS-1$

      PicInfoScrollPane info = new PicInfoScrollPane(this.iShowDisplayInfo);
      info.setPicturePanel(this.myPicturePanel);
      info.update(this.myFile, this.myShownWidth, this.myShownHeight);
      
      JPanel rtnMe = new JPanel(new BorderLayout());
      rtnMe.add(this.myPicInfoRows, BorderLayout.NORTH);
      rtnMe.add(info, BorderLayout.CENTER);

      return rtnMe;
   } 

   private void showExifTag(ImageUtilDrew drew, String label, int theTag)
   {
      String theData = drew.getExifString(theTag);
      if (theData != null)
      {
         JPanel aRow = this.myPicInfoRows.nextRow();
         aRow.add(new JLabel(label + ": " + theData)); //$NON-NLS-1$
      }
   }
}
