/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.jibs.viewer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;

import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.image.IOImage;
import org.gerhardb.lib.image.ImageFactory;
import org.gerhardb.lib.image.ImageUtilDrew;
import org.gerhardb.lib.util.Conversions;

/**
 * 
 * @author Gerhard Beck
 */
public class PicInfoScrollPane extends JScrollPane
{
	static SimpleDateFormat dateFormat = new SimpleDateFormat();
	boolean iShowDisplayInfo = false;
	JComponent myPicturePanel;

	public PicInfoScrollPane(boolean showDisplayInfo )
	{
		super();
		this.iShowDisplayInfo = showDisplayInfo;
	}
	
	public void setPicturePanel(JComponent picturePanel)
	{
		this.myPicturePanel = picturePanel;
	}
	
	/**
	 * 
	 * @param picFile
	 * @param displayInfoWidth
	 * @param displayInfoHeight
	 * @param showDisplayInfo Whether or not to show display width and height
	 * @param picturePanel OPTIONAL
	 */
	public void update(
	   	File picFile,
	      int displayInfoWidth,
	      int displayInfoHeight)
	{		
		if (picFile == null)
		{
			JEditorPane showMe = new JEditorPane("text", ""); //$NON-NLS-1$
			showMe.setEditable(false);
			showMe.setDisabledTextColor(Color.black);
			showMe.setCaretPosition(0);
			setViewportView(showMe);
			return;
		}	
		
		StringBuffer buff = new StringBuffer(3000);
		buff.append("<html>"); //$NON-NLS-1$

		buff.append("<center><strong>"); //$NON-NLS-1$
		buff.append("Picture File Data"); 
		buff.append("</strong></center>"); //$NON-NLS-1$

		buff.append("Name: "); //$NON-NLS-1$
		buff.append(picFile.getName()); 
		buff.append("<br>"); //$NON-NLS-1$

		buff.append("Size: "); //$NON-NLS-1$
		buff.append(Conversions.formattedMetricBytes(picFile.length())); 
		buff.append("<br>"); //$NON-NLS-1$

		buff.append("Last Modified: "); //$NON-NLS-1$
		buff.append(dateFormat.format(new Date(picFile.lastModified())));  
		buff.append("<br>"); //$NON-NLS-1$
		
		buff.append("<hr>"); //$NON-NLS-1$
		buff.append("<center><strong>"); //$NON-NLS-1$
		buff.append(Jibs.getString("PicInfoDialog.25")); //$NON-NLS-1$
		buff.append("</strong></center>"); //$NON-NLS-1$
		
		ImageUtilDrew drew = new ImageUtilDrew(picFile);
		ArrayList<?> exifTags = drew.getExifTags();
		if (exifTags.size() == 0)
		{
			buff.append(Jibs.getString("PicInfoDialog.27")); //$NON-NLS-1$
			buff.append("<br>"); //$NON-NLS-1$
		}
		else
		{
			Iterator<?> tags = exifTags.iterator();
			while (tags.hasNext())
			{
				buff.append(tags.next());
				buff.append("<br>"); //$NON-NLS-1$
			}
		}

		buff.append("<hr>"); //$NON-NLS-1$
		buff.append("<center><strong>"); //$NON-NLS-1$
		buff.append(Jibs.getString("PicInfoDialog.32")); //$NON-NLS-1$
		buff.append("</strong></center>"); //$NON-NLS-1$
		// buff.append("<br>");

		try
		{
			IOImage ioi = ImageFactory.getImageFactory().makeImage(picFile);
			BufferedImage actualImage = ioi.getImage();
			buff.append(Jibs.getString("PicInfoDialog.34") + Jibs.getString("colon") + " "); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			buff.append(actualImage.getWidth());
			buff.append(" " + Jibs.getString("PicInfoDialog.35") + Jibs.getString("colon") + " "); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
			buff.append(actualImage.getHeight());
			buff.append("<br>"); //$NON-NLS-1$
		}
		catch (Exception ex)
		{
			buff.append(Jibs.getString("PicInfoDialog.37")); //$NON-NLS-1$
		}

		if (this.iShowDisplayInfo)
		{
			if (displayInfoWidth > 0 && displayInfoHeight > 0)
			{
				buff.append(Jibs.getString("PicInfoDialog.38") + Jibs.getString("colon") + " "); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				buff.append(displayInfoWidth);
				buff.append(" " + Jibs.getString("PicInfoDialog.39") + Jibs.getString("colon") + Jibs.getString("PicInfoScrollPane.9")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				buff.append(displayInfoHeight);
				buff.append("<br>"); //$NON-NLS-1$
			}


			if ( this.myPicturePanel !=  null )
			{
				Dimension prefPanel = this.myPicturePanel.getPreferredSize();
				buff.append(Jibs.getString("PicInfoDialog.41") + Jibs.getString(Jibs.getString("PicInfoScrollPane.10")) + " "); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				buff.append(prefPanel.getWidth());
				buff.append(" " + Jibs.getString("PicInfoDialog.42") + Jibs.getString("colon") + " "); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				buff.append(prefPanel.getHeight());
				buff.append("<br>"); //$NON-NLS-1$
	
				buff.append(Jibs.getString("PicInfoDialog.44") + Jibs.getString("colon") + " "); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				buff.append(this.myPicturePanel.getWidth());
				buff.append(" " + Jibs.getString("PicInfoDialog.45") + Jibs.getString("colon") + " "); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$ //$NON-NLS-4$
				buff.append(this.myPicturePanel.getHeight());
			}
		}
		buff.append("</html>"); //$NON-NLS-1$

		String showString = buff.toString();
		JEditorPane showMe = new JEditorPane("text/html", showString); //$NON-NLS-1$
		showMe.setEditable(false);
		showMe.setDisabledTextColor(Color.black);
		showMe.setCaretPosition(0);

		try{setViewportView(showMe);}
		catch(Exception ex)
		{
			System.out.println("RANDOM CAUGHT EXCEPTION IN PicInfoScrollPane");
			System.out.println("KNOWN PROBLEM -->  DON'T WORRY...");
			ex.printStackTrace();
		}
	}
}
