/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.gerhardb.jibs.viewer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.frame.SortScreen;
import org.gerhardb.lib.dirtree.rdp.BasicOptionsManager;
import org.gerhardb.lib.swing.JPanelRows;

/**
 *
 * @author  Gerhard Beck
 */
public class VPDMainPanel
{
   // -------------- Set up Veiw Directory Options ---------------------
   JFormattedTextField delayFld =
      new JFormattedTextField(new Integer(3000));

   JCheckBox startFullScreenChkBox =
      new JCheckBox(Jibs.getString("VPDMainPanel.4")  //$NON-NLS-1$
    		  + "      "); //$NON-NLS-1$

   JCheckBox startShowImmediatelyChkBox =
      new JCheckBox(Jibs.getString("VPDMainPanel.6")); //$NON-NLS-1$
   
   JCheckBox gdFullScreenChkBox =
	      new JCheckBox(Jibs.getString("VPDMainPanel.7")); //$NON-NLS-1$

   JCheckBox continuousLoopChkBox =
      new JCheckBox(Jibs.getString("VPDMainPanel.94")); //$NON-NLS-1$

   JCheckBox blowUpChkBox =
      new JCheckBox(Jibs.getString("VPDMainPanel.11")); //$NON-NLS-1$

   JFormattedTextField maxBlowFld =
      new JFormattedTextField(new Integer(2));

   SortScreen mySortScreen;

   JPanel basicPanel = new JPanel(false);

   //===========================================================================
   //                              Constructor
   //===========================================================================
   public VPDMainPanel(SortScreen owner)
   {
      this.mySortScreen = owner;
   }
   
   JComponent setUpScreen()
   {
      this.delayFld.setColumns(10);
      this.maxBlowFld.setColumns(3);

      JPanelRows basicPanelRows = new JPanelRows();
      JPanel nextRow = basicPanelRows.topRow();
      nextRow.add(showStartup());

      nextRow = basicPanelRows.nextRow();
      nextRow.add(showComponent());
      nextRow.add(this.mySortScreen.getLST().getBasicOptionsManager().getSortComponent());

      this.basicPanel.add(basicPanelRows);

      this.delayFld.setValue(new Integer(ViewerPreferences.getSlideFlipDelay()));
      
      adjustView();
      return new JScrollPane(this.basicPanel); //$NON-NLS-1$
   } 

   // =========================================================================
   //                         Private Methods
   // =========================================================================
   private Component showStartup()
   {
      this.startFullScreenChkBox.setSelected(ViewerPreferences.startFullScreen());
      this.startFullScreenChkBox.setToolTipText(Jibs.getString("VPDMainPanel.45")); //$NON-NLS-1$     
      return this.mySortScreen.getLST().getBasicOptionsManager().getStartupComponent(this.startFullScreenChkBox);
      }

   private Component showComponent()
   {
      this.startShowImmediatelyChkBox.setSelected(ViewerPreferences.immediateShow());
      this.gdFullScreenChkBox.setSelected(ViewerPreferences.getGDFullScreen());
      this.continuousLoopChkBox.setSelected(ViewerPreferences.continuousShow());
      this.blowUpChkBox.setSelected(ViewerPreferences.blowUp());
      this.maxBlowFld.setValue(new Integer(ViewerPreferences.getMaxBlow()));

      this.blowUpChkBox.setToolTipText(
         Jibs.getString("VPDMainPanel.57")); //$NON-NLS-1$
      this.maxBlowFld.setToolTipText(
         "<html>" + Jibs.getString("VPDMainPanel.59") + "<br>" //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
         + Jibs.getString("VPDMainPanel.61") + "</html>"); //$NON-NLS-1$ //$NON-NLS-2$

      JPanelRows rtnMe = new JPanelRows();
      rtnMe.setToolTipText(Jibs.getString("VPDMainPanel.63")); //$NON-NLS-1$
      rtnMe.setBorder(
         new TitledBorder(
         new LineBorder(Color.BLACK),
         Jibs.getString("VPDMainPanel.64"), TitledBorder.LEFT, TitledBorder.TOP) ); //$NON-NLS-1$

      JPanel row = rtnMe.topRow();
      row.add(this.blowUpChkBox);
      row.add(new JLabel(" " + Jibs.getString("VPDMainPanel.66"))); //$NON-NLS-1$ //$NON-NLS-2$
      row.add(this.maxBlowFld);
      row.add(this.gdFullScreenChkBox);

      row = rtnMe.nextRow();
      row.add(this.startShowImmediatelyChkBox);

      row = rtnMe.nextRow();
      row.add(this.continuousLoopChkBox);

      row = rtnMe.nextRow();
      row.add(new JLabel(Jibs.getString("VPDMainPanel.67") + ": ")); //$NON-NLS-1$ //$NON-NLS-2$
      row.add(this.delayFld);
      row.add(new JLabel(Jibs.getString("VPDMainPanel.69"))); //$NON-NLS-1$
      return rtnMe;
   }

   private void adjustView()
   {
   	BasicOptionsManager bom = this.mySortScreen.getLST().getBasicOptionsManager();
   	bom.adjustView();

      // Turn the full screen on and off
      if (bom.getStartNothing())
      {
         this.startFullScreenChkBox.setEnabled(false);
         this.startFullScreenChkBox.setSelected(false);
      }
      else
      {
         this.startFullScreenChkBox.setEnabled(true);
      }
   }

   void save()
	{
   	try
   	{
	   	this.mySortScreen.getPathManager().save();
	   	this.mySortScreen.getLST().getBasicOptionsManager().save();
	
			ViewerPreferences.setGDFullScreen(this.gdFullScreenChkBox.isSelected());
	
			ViewerPreferences.setImmediateShow(this.startShowImmediatelyChkBox
					.isSelected());
			ViewerPreferences.setStartFullScreen(this.startFullScreenChkBox
					.isSelected());
	
			ViewerPreferences.setContinuousShow(this.continuousLoopChkBox.isSelected());
			ViewerPreferences.setBlowUp(this.blowUpChkBox.isSelected());
	
			int delay = 3000;
			try
			{
				Object newTime = this.delayFld.getValue();
				if (newTime instanceof Long)
				{
					delay = ((Long) newTime).intValue();
				}
				else if (newTime instanceof Integer)
				{
					delay = ((Integer) newTime).intValue();
				}
				else
				{
					//System.out.println("DELAY TYPE: "+ newTime.getClass().getName());
				}
			}
			catch (Exception ex)
			{
				ex.printStackTrace();
			}
			ViewerPreferences.setSlideFlipDelay(delay, this.mySortScreen.getScroller());
	
			int blow = 1;
			try
			{
				Object newBlow = this.maxBlowFld.getValue();
				if (newBlow instanceof Long)
				{
					blow = ((Long) newBlow).intValue();
				}
				else if (newBlow instanceof Integer)
				{
					blow = ((Integer) newBlow).intValue();
				}
				else
				{
					//System.out.println("DELAY TYPE: " + newBlow.getClass().getName());
				}
			}
			catch (Exception ex)
			{
				ex.printStackTrace();
			}
			ViewerPreferences.setMaxBlow(blow);
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
			JOptionPane.showMessageDialog(this.basicPanel, ex.getMessage(), Jibs
					.getString("save.failed"), //$NON-NLS-1$
					JOptionPane.ERROR_MESSAGE);
			return;
		}
	}
}
