/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.jibs.viewer.contact;

import java.awt.*;
import javax.swing.*;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.swing.JPanelRows;
import org.gerhardb.lib.swing.SwingUtils;

/**
 * ContactSheetDisplay
 */
public class ColorPanel extends JPanel
{   
	ContactSheetDisplay display;
   Color mySaveTextColor = Color.YELLOW;
   Color mySaveBackgroundColor = Color.BLACK;
   Color myPrintTextColor = Color.BLACK;
   Color myPrintBackgroundColor = Color.WHITE; 
	JLabel mySaveSample = makeSample(Jibs.getString("ContactSheetOptions.20")); //$NON-NLS-1$
	JLabel myPrintSample = makeSample(Jibs.getString("ContactSheetOptions.21"));   	 //$NON-NLS-1$
	
	ColorPanel(ContactSheetDisplay csd)
	{
		this.display = csd;
		
   	final JRadioButton saveText = new JRadioButton(Jibs.getString("ContactSheetOptions.91")); //$NON-NLS-1$
   	final JRadioButton saveBackground = new JRadioButton(Jibs.getString("ContactSheetOptions.92")); //$NON-NLS-1$
   	final JRadioButton printText = new JRadioButton(Jibs.getString("ContactSheetOptions.93")); //$NON-NLS-1$
   	final JRadioButton printBackground = new JRadioButton(Jibs.getString("ContactSheetOptions.94")); //$NON-NLS-1$
   	ButtonGroup bGroup = new ButtonGroup();
   	bGroup.add(saveText);
   	bGroup.add(saveBackground);
   	bGroup.add(printText);
   	bGroup.add(printBackground);
   	saveText.setSelected(true);
   	
   	final JColorChooser jcc = new JColorChooser(Color.WHITE);
   	jcc.getSelectionModel().addChangeListener(new ChangeListener()
      {
   		public void stateChanged(ChangeEvent e)
   		{
   	        Color newColor = jcc.getColor();
   	        //System.out.println(newColor + Jibs.getString("colon") + SwingUtils.ColorToString(newColor)); //$NON-NLS-1$
   	        if (saveText.isSelected())
   	        {
   	      	  ColorPanel.this.mySaveSample.setForeground(newColor);
   	      	  ColorPanel.this.mySaveTextColor = newColor;   	   	       
   	        }
   	        else if (saveBackground.isSelected())
   	        {
   	      	  ColorPanel.this.mySaveSample.setBackground(newColor);
   	      	  ColorPanel.this.mySaveBackgroundColor = newColor;
   	        }
   	        else if (printText.isSelected())
   	        {
   	      	  ColorPanel.this.myPrintSample.setForeground(newColor); 
   	      	  ColorPanel.this.myPrintTextColor = newColor;
   	        }
   	        else if (printBackground.isSelected())
   	        {
   	      	  ColorPanel.this.myPrintSample.setBackground(newColor);
      	        ColorPanel.this.myPrintBackgroundColor = newColor;
   	        }
   		}   		
      });
   	jcc.setPreviewPanel(new JPanel());
   	jcc.setBorder(BorderFactory.createTitledBorder(
	                                        Jibs.getString("ContactSheetOptions.96"))); //$NON-NLS-1$
   	   	
      JPanelRows samples = new JPanelRows();
      JPanel row = samples.topRow();
      row.add(saveText);
      
      row = samples.nextRow();
      row.add(saveBackground);
      
      row = samples.nextRow();
      row.add(this.mySaveSample);
      
      row = samples.nextRow();
      row.add(printText);
      
      row = samples.nextRow();
      row.add(printBackground);
      
      row = samples.nextRow();
      row.add(this.myPrintSample);
      
    	this.setLayout(new BorderLayout());
    	this.add(samples, BorderLayout.WEST);
      this.add(jcc, BorderLayout.EAST);
   }
	
   JLabel makeSample(String text)
   {
     	Dimension dim = new Dimension(180,40);
   	JLabel rtnMe = new JLabel(text);
   	rtnMe.setPreferredSize(dim);
   	rtnMe.setMinimumSize(dim);
   	rtnMe.setHorizontalAlignment(SwingConstants.CENTER);
   	rtnMe.setOpaque(true);
   	rtnMe.setBackground(Color.WHITE);
   	rtnMe.setForeground(Color.BLACK);
   	rtnMe.setFont(new Font("SansSerif", Font.BOLD, 18)); //$NON-NLS-1$
   	return rtnMe;
   }
   
   // **************************************************************************
   // PREFERENCES
   // **************************************************************************
   private static final String CT_CLR_SAVE_TEXT = "ct_clr_save_test"; //$NON-NLS-1$
   private static final String CT_CLR_SAVE_BACK = "ct_clr_save_back"; //$NON-NLS-1$
   private static final String CT_CLR_PRT_TEXT = "ct_clr_prt_text"; //$NON-NLS-1$
   private static final String CT_CLR_PRT_BACK = "ct_clr_prt_back"; //$NON-NLS-1$
   
   void savePreferences()
   {
   	this.display.myPrefs.put(CT_CLR_SAVE_TEXT, SwingUtils.ColorToString(this.mySaveTextColor));
   	this.display.myPrefs.put(CT_CLR_SAVE_BACK, SwingUtils.ColorToString(this.mySaveBackgroundColor));
   	this.display.myPrefs.put(CT_CLR_PRT_TEXT, SwingUtils.ColorToString(this.myPrintTextColor));
   	this.display.myPrefs.put(CT_CLR_PRT_BACK, SwingUtils.ColorToString(this.myPrintBackgroundColor));     	
  }	

   void lookupPrefences()
   {
   	//HKEY_CURRENT_USER\Software\JavaSoft\Prefs
      this.mySaveTextColor = SwingUtils.StringToColor(this.display.myPrefs.get(CT_CLR_SAVE_TEXT, "0,0,255,255")); //$NON-NLS-1$
      this.mySaveBackgroundColor = SwingUtils.StringToColor(this.display.myPrefs.get(CT_CLR_SAVE_BACK, "0,0,0,255")); //$NON-NLS-1$
      this.myPrintTextColor = SwingUtils.StringToColor(this.display.myPrefs.get(CT_CLR_PRT_TEXT, "0,0,0,255")); //$NON-NLS-1$
      this.myPrintBackgroundColor = SwingUtils.StringToColor(this.display.myPrefs.get(CT_CLR_PRT_BACK, "255,255,255,255")); //$NON-NLS-1$
      
      this.mySaveSample.setForeground(this.mySaveTextColor);
      this.mySaveSample.setBackground(this.mySaveBackgroundColor);
      this.myPrintSample.setForeground(this.myPrintTextColor);
      this.myPrintSample.setBackground(this.myPrintBackgroundColor);
   }   
}
