/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.jibs.viewer.contact;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.io.FileUtil;
import org.gerhardb.lib.swing.JPanelRows;

/**
 * FilePanel
 */
public class FilePanel extends JPanel
{
   private static final String CT_USE_SELECTED = "ct_use_selected"; //$NON-NLS-1$
   private static final String CT_USE_ALL = "ct_use_all"; //$NON-NLS-1$
   private static final String CT_USE_DIR = "ct_use_idr"; //$NON-NLS-1$
   
	ContactSheetDisplay display;
	
   SavePanel savePanel;
   JLabel myDescription = new JLabel("");
   JTextField myShowDirFld = new JTextField(40);
   JButton myBtnDir = new JButton("..."); //$NON-NLS-1$
   JRadioButton myUseSelectedFiles = new JRadioButton(Jibs.getString("ContactSheetOptions.1")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
   JRadioButton myUseAllFilesCurrentlyShownInBrowser = new JRadioButton("Use all files currently shown in browser");
   JRadioButton myUseDirectory = new JRadioButton(Jibs.getString("ContactSheetOptions.11") + Jibs.getString("colon") + " "); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
   JCheckBox myWalkTree = new JCheckBox(Jibs.getString("ContactSheetOptions.14")); //$NON-NLS-1$  Use Sub Directories
   
   // Progress printing pages in a directory
   JProgressBar myPageBar = new JProgressBar();
   
   // Progress pinting pictures on a page
   JProgressBar myPicBar = new JProgressBar();
  
	FilePanel(ContactSheetDisplay csd)
	{
		this.display = csd;
   	this.savePanel = new SavePanel(this.display);
		
	     this.myBtnDir.addActionListener
	      (
	      new ActionListener()
			   {
			      public void actionPerformed(ActionEvent ae)
			      {
			         String dir = FilePanel.this.myShowDirFld.getText();
			         if (dir == null)
			         {
			            dir = System.getProperty("user.home"); //$NON-NLS-1$
			         }
		            dir = FileUtil.lookupDir(Jibs.getString("ContactSheetOptions.25"), dir, FilePanel.this.display.myFrame); //$NON-NLS-1$
			         FilePanel.this.myShowDirFld.setText(dir);
			      }
			   }
			   );
	      

	      this.myUseSelectedFiles.setSelected(this.display.myPrefs.getBoolean(CT_USE_SELECTED, true));      
	      this.myUseAllFilesCurrentlyShownInBrowser.setSelected(this.display.myPrefs.getBoolean(CT_USE_ALL, false));      
	      this.myUseDirectory.setSelected(this.display.myPrefs.getBoolean(CT_USE_DIR, false));    
	      
	      ButtonGroup aGroup = new ButtonGroup();
	      aGroup.add(this.myUseAllFilesCurrentlyShownInBrowser);
	      aGroup.add(this.myUseSelectedFiles);
	      aGroup.add(this.myUseDirectory);
	 
	 	   String description = this.display.myScroller.getDescription();
	 	   this.myDescription.setText(description);
	 
	      this.myUseSelectedFiles.addActionListener(new ActionListener(){
	     	  public void actionPerformed(ActionEvent e)
	     	  {
	     	      setButtons();
	     	  }    	  
	       });
	      
	      this.myUseAllFilesCurrentlyShownInBrowser.addActionListener(new ActionListener(){
	      	  public void actionPerformed(ActionEvent e)
	      	  {
	      	      setButtons();
	      	  }    	  
	        });
	       
	       this.myUseDirectory.addActionListener(new ActionListener(){
	       	  public void actionPerformed(ActionEvent e)
	       	  {
	       	      setButtons();
	       	  }    	  
	         });

	      JPanelRows jpr = new JPanelRows();
	      JPanel row = jpr.topRow();
	      
	      if (csd.iShowOnlySelectedFiles && csd.mySelectedFiles != null && csd.mySelectedFiles.length > 0)
	      {
	      	if (csd.mySelectedFiles.length == 1)
	      	{
	      		row.add(new JLabel("Showing: " + csd.mySelectedFiles[0]));
	      	}
	      	else
	      	{
	      		row.add(new JLabel("Showing several pre-selected files"));	      		
	      	}
	      }
	      else
	      {
		      row.add(this.myUseSelectedFiles); 
		      
		      row = jpr.nextRow(); 
		      row.add(this.myUseAllFilesCurrentlyShownInBrowser);
		      row.add(this.myDescription);
		      
		      row = jpr.nextRow(); 
		      row.add(this.myUseDirectory); 
		      row.add(this.myShowDirFld);
		      row.add(this.myBtnDir);   	
		      
		      row = jpr.nextRow();
		      row.add(this.myWalkTree);
	      }
	      
	      row = jpr.nextRow();
	      row.add(this.savePanel);
	      
	      row = jpr.nextRow();
	      row.add(new PrintPanel(this.display));		
	      
	      JPanel progressBars = new JPanel(new BorderLayout());
	      progressBars.add(this.myPicBar, BorderLayout.NORTH);
	      progressBars.add(this.myPageBar, BorderLayout.SOUTH);
	      
	      this.setLayout(new BorderLayout());
	      this.add(jpr, BorderLayout.NORTH);
	      this.add(progressBars, BorderLayout.SOUTH);
	      
	   	setButtons();
    }  
	
   void setButtons()
   {
  		this.myShowDirFld.setEnabled(false);
		this.myBtnDir.setEnabled(false);
		this.myWalkTree.setEnabled(false);
   	
		if (this.myUseDirectory.isSelected())
		{
	  		this.myShowDirFld.setEnabled(true);
   		this.myBtnDir.setEnabled(true);
   		this.myWalkTree.setEnabled(true);
		}
   }

   boolean showFilesNotDirectories()
   {
 		if (this.myUseSelectedFiles.isSelected())
		{
			return true;
		}
		else if (this.myUseAllFilesCurrentlyShownInBrowser.isSelected())
		{
			return true;
		}
		else if (this.myUseDirectory.isSelected())
		{
			return false;
		}
 		// Should never get to here!
 		return true;
   }
   	
	// **************************************************************************
   // PREFERENCES
   // **************************************************************************
 
   private static final String CT_DIRECTORY = "ct_directory"; //$NON-NLS-1$
   private static final String CT_TREE_WALK = "ct_tree_walk"; //$NON-NLS-1$

   void savePreferences()
   {
   	this.savePanel.savePreferences();
    	this.display.myPrefs.put(CT_DIRECTORY, this.myShowDirFld.getText());
      this.display.myPrefs.putBoolean(CT_TREE_WALK, this.myWalkTree.isSelected());
      
      this.display.myPrefs.putBoolean(CT_USE_SELECTED, this.myUseSelectedFiles.isSelected());
      this.display.myPrefs.putBoolean(CT_USE_DIR, this.myUseDirectory.isSelected());
      this.display.myPrefs.putBoolean(CT_USE_ALL, this.myUseAllFilesCurrentlyShownInBrowser.isSelected());
   }	

   void lookupPrefences()
   {
     	this.savePanel.lookupPreferences();
      this.myShowDirFld.setText(this.display.myPrefs.get(CT_DIRECTORY, System.getProperty("user.home"))); //$NON-NLS-1$
      this.myWalkTree.setSelected(this.display.myPrefs.getBoolean(CT_TREE_WALK, false));
  }   
}
