/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.jibs.viewer.contact;

import java.awt.*;
import javax.swing.*;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.swing.JPanelRows;

/**
 * ContactSheetDisplay
 */
public class FontsPanel extends JPanelRows
{   
	ContactSheetDisplay display;
	
   JComboBox myHeaderFont;
   JComboBox myFooterFont;
   JComboBox myPictureFont;
   JFormattedTextField myHeaderFontSize = new JFormattedTextField(new Integer(100));
   JFormattedTextField myFooterFontSize = new JFormattedTextField(new Integer(100));
   JFormattedTextField myPictureFontSize = new JFormattedTextField(new Integer(100));
   
   FontsPanel(ContactSheetDisplay csd)
	{
		this.display = csd;
		
   	final JTextField myHeaderSample = new JTextField(Jibs.getString("ContactSheetOptions.72")); //$NON-NLS-1$
   	myHeaderSample.setEditable(false);
   	myHeaderSample.setBorder(null);
   	final JTextField myFooterSample = new JTextField(Jibs.getString("ContactSheetOptions.73")); //$NON-NLS-1$
   	myFooterSample.setEditable(false);
   	myFooterSample.setBorder(null);
   	final JTextField myPictureSample = new JTextField(Jibs.getString("ContactSheetOptions.74")); //$NON-NLS-1$
   	myPictureSample.setEditable(false);
   	myPictureSample.setBorder(null);
   	
    	this.myHeaderFontSize.setColumns(4);
   	this.myFooterFontSize.setColumns(4);
   	this.myPictureFontSize.setColumns(4); 	
   	
      GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
      String[] fonts = ge.getAvailableFontFamilyNames();  	
   	
      // Sized by the FontCellRenderer setting.
      this.myHeaderFont = new JComboBox(fonts);
      this.myFooterFont = new JComboBox(fonts);
      this.myPictureFont = new JComboBox(fonts);   

     	ListCellRenderer renderer = new FontCellRenderer(fonts);
   	this.myHeaderFont.setRenderer(renderer);
   	this.myFooterFont.setRenderer(renderer);
   	this.myPictureFont.setRenderer(renderer);    

   	this.myHeaderFont.addActionListener(new java.awt.event.ActionListener()
      {
         public void actionPerformed(java.awt.event.ActionEvent ae)
         {
         	String fontFamily = FontsPanel.this.myHeaderFont.getModel().getSelectedItem().toString();
         	//int size = ContactSheetOptions.this.getHeaderFontSize();
         	//myHeaderSample.setText(fontFamily);
         	myHeaderSample.setFont(new Font(fontFamily, Font.PLAIN, 14));
         }
      });   	

   	this.myFooterFont.addActionListener(new java.awt.event.ActionListener()
     	      {
     	         public void actionPerformed(java.awt.event.ActionEvent ae)
     	         {
     	         	String fontFamily = FontsPanel.this.myFooterFont.getModel().getSelectedItem().toString();
     	         	//int size = ContactSheetOptions.this.getHeaderFontSize();
     	         	//myHeaderSample.setText(fontFamily);
     	         	myFooterSample.setFont(new Font(fontFamily, Font.PLAIN, 14));
     	         }
     	      });   	

   	this.myPictureFont.addActionListener(new java.awt.event.ActionListener()
     	      {
     	         public void actionPerformed(java.awt.event.ActionEvent ae)
     	         {
     	         	String fontFamily = FontsPanel.this.myPictureFont.getModel().getSelectedItem().toString();
     	         	//int size = ContactSheetOptions.this.getHeaderFontSize();
     	         	//myHeaderSample.setText(fontFamily);
     	         	myPictureSample.setFont(new Font(fontFamily, Font.PLAIN, 14));
     	         }
     	      });   	

     	   	
      JPanel row = this.topRow();
      row.add(new JLabel(Jibs.getString("ContactSheetOptions.75") + Jibs.getString("colon") + " "));  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
      row.add(this.myHeaderFont);
      row.add(new JLabel(Jibs.getString("ContactSheetOptions.78") + Jibs.getString("colon") + " "));  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
      row.add(this.myHeaderFontSize);
      row.add(myHeaderSample);
         
      row = this.nextRow();
      row.add(new JLabel(Jibs.getString("ContactSheetOptions.81") + Jibs.getString("colon") + " "));  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
      row.add(this.myPictureFont);
      row.add(new JLabel(Jibs.getString("ContactSheetOptions.84") + Jibs.getString("colon") + " "));  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
      row.add(this.myPictureFontSize);
      row.add(myPictureSample);

      row = this.nextRow();
      row.add(new JLabel(Jibs.getString("ContactSheetOptions.87") + Jibs.getString("colon") + "   "));  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
      row.add(this.myFooterFont);
      row.add(new JLabel(Jibs.getString("ContactSheetOptions.88") + Jibs.getString("colon") + " "));  //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
      row.add(this.myFooterFontSize);
      row.add(myFooterSample);   	
   }
   
	int getPictureFontSize()
	{
		try{return Integer.parseInt(this.myPictureFontSize.getText());}
		catch(Exception ex){ex.printStackTrace();}
		return 10;
	}
	
	int getHeaderFontSize()
	{
		try{return Integer.parseInt(this.myHeaderFontSize.getText());}
		catch(Exception ex)
      {
      	ex.printStackTrace();
      }
		return 10;
	}
	
	int getFooterFontSize()
	{
		try{return Integer.parseInt(this.myFooterFontSize.getText());}
		catch(Exception ex)
      {
      	ex.printStackTrace();
      }
		return 10;
	}
	
   class FontCellRenderer extends JLabel implements ListCellRenderer 
   {
   	String[] myFonts;
      public FontCellRenderer(String[] fonts)
		{
      	this.myFonts = fonts;
			setOpaque(true);
			setPreferredSize(new Dimension(220, 20));
		}
      public Component getListCellRendererComponent(
          JList list,
          Object value,
          int index,
          boolean isSelected,
          boolean cellHasFocus)
      {
          setText(value.toString());
          if ( index > -1)
          {
         	 this.setFont(new Font(this.myFonts[index], Font.PLAIN, 16));
          }
          return this;
      }
   }  
   
   // **************************************************************************
   // PREFERENCES
   // **************************************************************************
   private static final String CT_PIC_FONT = "ct_pic_font"; //$NON-NLS-1$
   private static final String CT_HEADER_FONT = "ct_header_font"; //$NON-NLS-1$
   private static final String CT_FOOTER_FONT = "ct_footer_font"; //$NON-NLS-1$
   private static final String CT_PIC_FONT_SIZE = "ct_pic_font_size"; //$NON-NLS-1$
   private static final String CT_HEADER_FONT_SIZE = "ct_header_font_size"; //$NON-NLS-1$
   private static final String CT_FOOTER_FONT_SIZE = "ct_footer_font_size"; //$NON-NLS-1$
   
   void savePreferences()
   {
    	this.display.myPrefs.put(CT_HEADER_FONT, this.myHeaderFont.getModel().getSelectedItem().toString());
    	this.display.myPrefs.put(CT_FOOTER_FONT, this.myFooterFont.getModel().getSelectedItem().toString());
    	this.display.myPrefs.put(CT_PIC_FONT, this.myPictureFont.getModel().getSelectedItem().toString());
     	this.display.myPrefs.put(CT_HEADER_FONT_SIZE, this.myHeaderFontSize.getText());
     	this.display.myPrefs.put(CT_FOOTER_FONT_SIZE, this.myFooterFontSize.getText());
     	this.display.myPrefs.put(CT_PIC_FONT_SIZE, this.myPictureFontSize.getText());
  }	

   void lookupPrefences()
   {
   	//HKEY_CURRENT_USER\Software\JavaSoft\Prefs      
      this.myHeaderFont.getModel().setSelectedItem(this.display.myPrefs.get(CT_HEADER_FONT, "SansSerif")); //$NON-NLS-1$
      this.myFooterFont.getModel().setSelectedItem(this.display.myPrefs.get(CT_FOOTER_FONT, "SansSerif")); //$NON-NLS-1$
      this.myPictureFont.getModel().setSelectedItem(this.display.myPrefs.get(CT_PIC_FONT, "SansSerif")); //$NON-NLS-1$
      this.myHeaderFontSize.setText(this.display.myPrefs.get(CT_HEADER_FONT_SIZE, "10")); //$NON-NLS-1$
      this.myFooterFontSize.setText(this.display.myPrefs.get(CT_FOOTER_FONT_SIZE, "10")); //$NON-NLS-1$
      this.myPictureFontSize.setText(this.display.myPrefs.get(CT_PIC_FONT_SIZE, "10")); //$NON-NLS-1$
   }   
}
