/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.jibs.viewer.contact;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import org.gerhardb.lib.swing.JPanelRows;

/**
 * FilePanel
 */
public class OtherPanel extends JPanelRows
{

	ContactSheetDisplay display;
	
   JTextField myPdfViewerFld = new JTextField(40);
   JButton myBtnPdf = new JButton("..."); //$NON-NLS-1$
   
   OtherPanel(ContactSheetDisplay csd)
	{
		this.display = csd;
		
	     this.myBtnPdf.addActionListener
	      (
	      new ActionListener()
			   {
			public void actionPerformed(ActionEvent ae)
			{
				String dir = OtherPanel.this.myPdfViewerFld.getText();
				if (dir == null)
				{
					dir = System.getProperty("user.home"); //$NON-NLS-1$
				}
				
				JFileChooser chooser = new JFileChooser();
				chooser.setDialogTitle("Select PDF Viwer");
				chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
				chooser.setCurrentDirectory(new File(dir));

				int returnVal = chooser.showOpenDialog(OtherPanel.this);
				if (returnVal == JFileChooser.APPROVE_OPTION)
				{
					try
					{
						File picked = chooser.getSelectedFile();
						if (picked != null && picked.exists() && picked.isFile())
						{
							OtherPanel.this.myPdfViewerFld.setText( picked.getAbsolutePath());
						}
					}
					catch (Exception ex)
					{
						ex.printStackTrace();
					}
				}
			}
			   }
			   );
	     
		JPanel aRow = super.topRow();
		
		aRow.add(new JLabel("Path to PDF Viewer: "));
		aRow.add(this.myPdfViewerFld);
		aRow.add(this.myBtnPdf);
	}
	
   void display(File pdf)
   {
   	if (pdf == null || !pdf.exists())
   	{
   		return;
   	}
   	
   	String viewer = this.myPdfViewerFld.getText();
   	if (viewer == null || viewer.length() == 0)
   	{
   		return;
   	}
   	
		File file = new File(viewer);
		if (file.exists() && file.isFile())
		{
			try
			{
				Runtime.getRuntime().exec(file.getAbsolutePath() + " " + pdf.getAbsoluteFile() ); 
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}  	
   }
   
	// **************************************************************************
   // PREFERENCES
   // **************************************************************************
 
   private static final String CT_PDF_VIEWER = "ct_pdf_viewer"; //$NON-NLS-1$

   void savePreferences()
   {
    	this.display.myPrefs.put(CT_PDF_VIEWER, this.myPdfViewerFld.getText());
   }	

   void lookupPrefences()
   {
     	this.myPdfViewerFld.setText(this.display.myPrefs.get(CT_PDF_VIEWER, "")); 
  }   
}
