/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.jibs.viewer.contact;

import java.awt.Color;
import javax.swing.*;
import javax.swing.border.Border;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.print.*;
import org.gerhardb.lib.print.contactSheet.*;
import org.gerhardb.lib.swing.JPanelRows;

/**
 * ContactSheetDisplay
 */
class PrintPanel extends JPanelRows
{
   ContactSheetDisplay display;
   
   PrintPanel(ContactSheetDisplay csd)
   {     
   	this.display = csd;
		this.setBackground(Color.BLUE);
		
		JButton previewPrintBtn = new JButton("Preview Print"); //$NON-NLS-1$
		previewPrintBtn.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent ae)
			{
				PageLayout pl = getSavedPageLayout(); 
		   	ContactSheetPageable csp = PrintPanel.this.display.makePageable(pl, true, true);
		   	if (csp != null)
		   	{
		   		new PageablePreviewer(csp,	false, makePDFbutton());
		   	}
			}
			});

		
		JButton printBtn = new JButton(Jibs.getString("print")); //$NON-NLS-1$ //new JButton(Jibs.getString("ContactSheetPrintOptions.4")); //$NON-NLS-1$
		printBtn.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent ae)
			{
				PageLayout pl = getSavedPageLayout(); 
		   	ContactSheetPageable csp = PrintPanel.this.display.makePageable(pl, true, false);
		   	if (csp!= null)
		   	{
		   		PageableUtils.printToPrinter(csp, PrintPanel.this.display.myFrame, PrintPanel.this.display.filePanel.myPageBar);
		   	}
			}
		});		
		
		JButton pageBtn = new JButton(Jibs.getString("ContactSheetOptions.2")); //$NON-NLS-1$
		pageBtn.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent ae)
			{
				/*
				PageFormat showMe = getSavedPageFormat();
				PrinterJob pj = PrinterJob.getPrinterJob();
				PageFormat pf = pj.pageDialog(showMe);
				PageFormat saveMe = pj.validatePage(pf);
				saveOptions(saveMe);
				*/
				PageLayout pl = getSavedPageLayout(); 
				PageLayoutDialog dialog = new PageLayoutDialog(PrintPanel.this.display.myFrame, pl);
				PageLayout updatedLayout = dialog.getPageLayout();
				saveLayout(updatedLayout);
			}
		});
		
   	Border loweredbevel = BorderFactory.createLoweredBevelBorder();
   	this.setBorder(loweredbevel);
   	
		JPanel row = this.nextRow();
		row.add(pageBtn);
		row.add(previewPrintBtn);
		//row.add(printBtn);
		row.add(makePDFbutton());

		previewPrintBtn.requestFocus();
   }
   
   JButton makePDFbutton()
   {
		JButton pdfBtn = new JButton(Jibs.getString("print") + " PDF"); //$NON-NLS-1$ //new JButton(Jibs.getString("ContactSheetPrintOptions.4")); //$NON-NLS-1$
		pdfBtn.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent ae)
			{
				Runnable runMe = new Runnable()
				{
					public void run()
					{
						printIText(); 
					}
				};
				new Thread(runMe).start();	
			}
		});		
		return pdfBtn;
   }
   
   void printIText()
   {
		PageLayout pl = getSavedPageLayout();
    	try
     	{
    		ContactSheetDisplay.DisplayInfo info = PrintPanel.this.display.getDisplayInfo(pl, false, false);
     	  	new ContactSheetPDF(
	    			info.fileList, 
	    			info.showFilesNotDirectories, 
	    			info.pageLayout, 
	    			info.headerFooterInfo, 
	    			info.contactSheetInfo, 
	    			PrintPanel.this.display.getFileToSavePDFto(), 
	    			PrintPanel.this.display.myFrame, 
	    			PrintPanel.this.display.filePanel.myPageBar);
     	  	this.display.otherPanel.display(this.display.getFileToSavePDFto()); 
     	}
     	catch(Exception ex)
     	{
     		ex.printStackTrace();
			JOptionPane.showMessageDialog(PrintPanel.this.display.myFrame, ex.getMessage(), Jibs.getString("problem"), JOptionPane.ERROR_MESSAGE);
     	}  
   }
   
   /*
   private PageLayout getPageLayout()
   {
   	PageFormat pf = getSavedPageFormat();
   	// This adjusts the paper to landscape.
   	//PageLayout rtnMe = PageLayout.makeDPI(			(int)pf.getWidth(), (int)pf.getHeight(),   			(int)pf.getImageableX(), (int)pf.getImageableY(),   			(int)pf.getImageableWidth(), (int)pf.getImageableHeight());
   	// This leaves paper upright.
    	PageLayout rtnMe = PageLayout.makeDPI(
   			(int)pf.getPaper().getWidth(), (int)pf.getPaper().getHeight(), 
   			(int)pf.getPaper().getImageableX(), (int)pf.getPaper().getImageableY(), 
   			(int)pf.getPaper().getImageableWidth(), (int)pf.getPaper().getImageableHeight());
   	//rtnMe.setPortrait(pf.getOrientation() == PageFormat.PORTRAIT);
   	return rtnMe;
   }
	*/
     
   // **************************************************************************
   // PREFERENCES
   // **************************************************************************
   private static final String STORE_PAGE_WIDTH = "print_page_width"; //$NON-NLS-1$
   private static final String STORE_PAGE_HEIGHT = "print_page_height"; //$NON-NLS-1$
   private static final String STORE_X = "print_store_x"; //$NON-NLS-1$
   private static final String STORE_Y = "print_store_y"; //$NON-NLS-1$
   private static final String STORE_WIDTH = "print_store_width"; //$NON-NLS-1$
   private static final String STORE_HEIGHT = "print_store_height"; //$NON-NLS-1$
   //private static final String ORIENTATION = "PRINT_ORIENTATION"; //$NON-NLS-1$
   
   void saveLayout(PageLayout layout)
   {
		this.display.saveOptions();		
      this.display.myPrefs.putInt(STORE_X, layout.getInteriorLayout().getLeftMargin());
      this.display.myPrefs.putInt(STORE_Y, layout.getInteriorLayout().getTopMargin());
      this.display.myPrefs.putInt(STORE_WIDTH, layout.getInteriorLayout().getWidth());
      this.display.myPrefs.putInt(STORE_HEIGHT, layout.getInteriorLayout().getHeight());
      this.display.myPrefs.putInt(STORE_PAGE_WIDTH, layout.getPageWidth());
      this.display.myPrefs.putInt(STORE_PAGE_HEIGHT, layout.getPageHeight());    
      try{this.display.myPrefs.flush();}catch(Exception ex){ex.printStackTrace();}
   }	

   PageLayout getSavedPageLayout()
   {
   	//HKEY_CURRENT_USER\Software\JavaSoft\Prefs
   	PageLayout defaultLayout = PageLayout.makeDefault();
   	int pageWidth = this.display.myPrefs.getInt(STORE_PAGE_WIDTH, defaultLayout.getPageWidth());
   	int pageHeight = this.display.myPrefs.getInt(STORE_PAGE_HEIGHT, defaultLayout.getPageHeight());
   	int left = this.display.myPrefs.getInt(STORE_X, defaultLayout.getInteriorLayout().getLeftMargin());
   	int top = this.display.myPrefs.getInt(STORE_Y, defaultLayout.getInteriorLayout().getTopMargin());
   	int usableWidth = this.display.myPrefs.getInt(STORE_WIDTH, defaultLayout.getInteriorLayout().getWidth());
   	int usableHeight = this.display.myPrefs.getInt(STORE_HEIGHT, defaultLayout.getInteriorLayout().getHeight());   	
   	return PageLayout.makeDPI(pageWidth, pageHeight, left, top, usableWidth, usableHeight);
   }   
   
   /*
   private void saveOptions(PageFormat pageFormat)
   {
		this.display.saveOptions();
		
		// First save the orientation.
      this.display.myPrefs.putInt(ORIENTATION, pageFormat.getOrientation());
      
      // Java assume page is always portrait and converts to landscape in PageFormat upon requesting H or W.
      // So we clone and set to portrait before saving.
      PageFormat portrait = (PageFormat)pageFormat.clone();
      portrait.setOrientation(PageFormat.PORTRAIT);
      
      this.display.myPrefs.putDouble(PRINTABLE_X, portrait.getImageableX());
      this.display.myPrefs.putDouble(PRINTABLE_Y, portrait.getImageableY());
      this.display.myPrefs.putDouble(PRINTABLE_WIDTH, portrait.getImageableWidth());
      this.display.myPrefs.putDouble(PRINTABLE_HEIGHT, portrait.getImageableHeight());
      this.display.myPrefs.putDouble(PAGE_WIDTH, portrait.getWidth());
      this.display.myPrefs.putDouble(PAGE_HEIGHT, portrait.getHeight());      
		//System.out.println("SAVING PageFormat " + PrintUtils.showPageFormat(portrait)); //$NON-NLS-1$
   }	
   
   private PageFormat getSavedPageFormat()
   {
		PageFormat defaultFormat = new PageFormat();		
		Paper p = new Paper();
		p.setImageableArea(
				this.display.myPrefs.getDouble(PRINTABLE_X, defaultFormat.getImageableX()), 
				this.display.myPrefs.getDouble(PRINTABLE_Y, defaultFormat.getImageableY()), 
				this.display.myPrefs.getDouble(PRINTABLE_WIDTH, defaultFormat.getImageableWidth()), 
				this.display.myPrefs.getDouble(PRINTABLE_HEIGHT, defaultFormat.getImageableHeight()));
		p.setSize(
				this.display.myPrefs.getDouble(PAGE_WIDTH, defaultFormat.getWidth()), 
				this.display.myPrefs.getDouble(PAGE_HEIGHT, defaultFormat.getHeight()));		
		PageFormat rtnMe = new PageFormat();
		rtnMe.setOrientation(this.display.myPrefs.getInt(ORIENTATION, PageFormat.PORTRAIT));		
		rtnMe.setPaper(p);
		return rtnMe;      
   }   
   */

}
