/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.jibs.viewer.contact;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.*;
import javax.swing.border.Border;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.io.FileUtil;
import org.gerhardb.lib.print.*;
import org.gerhardb.lib.print.contactSheet.*;
import org.gerhardb.lib.swing.JPanelRows;

public class SavePanel extends JPanelRows
{
	//public static final File SAVE_PDF_TO = new File("D:/trash/gnuJpdf-PageablePreviewer.pdf");
	ContactSheetDisplay display;
	JTextField myNameFld = new JTextField(10);
	JTextField mySaveDirFld = new JTextField(40);
	JTextField mySavePdfFld = new JTextField(40);

	SavePanel(ContactSheetDisplay csd)
	{
		this.display = csd;
		this.setBackground(Color.CYAN);
		Border loweredbevel = BorderFactory.createLoweredBevelBorder();
		this.setBorder(loweredbevel);

		JButton saveBtn = new JButton(Jibs.getString("save")); //$NON-NLS-1$
		saveBtn.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent ae)
			{
				PageLayout pl = getSavedPageLayout(); 
				ContactSheetPageable csp = SavePanel.this.display.makePageable(pl, false, false);
				if (csp != null)
				{
					PageableUtils.saveAsJpg(csp, SavePanel.this.display.myFrame, SavePanel.this.display.filePanel.myPageBar);
				}
			}
		});

		JButton previewSaveBtn = new JButton("Preview Save"); //$NON-NLS-1$
		previewSaveBtn.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent ae)
			{
				PageLayout pl = getSavedPageLayout(); 
				ContactSheetPageable csp = SavePanel.this.display.makePageable(pl, false, true);
				if (csp != null)
				{
					new PageablePreviewer(csp, false, makePDFbutton());
				}
			}
		});

		JButton btnDir = new JButton("..."); //$NON-NLS-1$
		btnDir.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				String dir = SavePanel.this.mySaveDirFld.getText();
				if (dir == null)
				{
					dir = System.getProperty("user.home"); //$NON-NLS-1$
				}
				dir = FileUtil.lookupDir(
								Jibs.getString("ContactSheetSaveOptions.5"), dir, SavePanel.this.display.myFrame); //$NON-NLS-1$
				SavePanel.this.mySaveDirFld.setText(dir);
			}
		});

		JButton btnPdfLookup = new JButton("..."); //$NON-NLS-1$
		btnPdfLookup.addActionListener(new ActionListener()
		{
			public void actionPerformed(ActionEvent ae)
			{
				String file = SavePanel.this.mySavePdfFld.getText();
				if (file == null)
				{
					file = System.getProperty("user.home"); //$NON-NLS-1$
				}
				JFileChooser chooser = new JFileChooser();
				chooser.setDialogTitle("Select File to save PDF to"); //$NON-NLS-1$
				chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
				chooser.setCurrentDirectory(new File(file));
				int returnVal = chooser.showOpenDialog(SavePanel.this);
				if (returnVal == JFileChooser.APPROVE_OPTION)
				{
					try
					{
						String fileName = chooser.getSelectedFile().getAbsolutePath();
						System.out.println(fileName);
						if (fileName != null)
						{ 
							SavePanel.this.mySavePdfFld.setText(fileName);
						}
					}
					catch (Exception ex)
					{
						JOptionPane.showMessageDialog(SavePanel.this, ex
								.getMessage(), "PDF File Name Problem", //$NON-NLS-1$
								JOptionPane.ERROR_MESSAGE);
					}
				}
			}
		});

		JButton pageBtn = new JButton(Jibs.getString("ContactSheetOptions.2")); //$NON-NLS-1$
		pageBtn.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent ae)
			{
				PageLayout pl = getSavedPageLayout(); 
				PageLayoutDialog dialog = new PageLayoutDialog(SavePanel.this.display.myFrame, pl);
				PageLayout updatedLayout = dialog.getPageLayout();
				saveLayout(updatedLayout);
			}
		});

		JPanel row = this.nextRow();
		row.add(new JLabel(
						Jibs.getString("ContactSheetSaveOptions.25") + Jibs.getString("colon") + " ")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		row.add(this.myNameFld);

		row = this.nextRow();
		row.add(new JLabel(
						Jibs.getString("ContactSheetSaveOptions.28") + Jibs.getString("colon") + " ")); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
		row.add(this.mySaveDirFld);
		row.add(btnDir);


		row = this.nextRow();
		row.add(new JLabel("Save PDF to:"));
		row.add(this.mySavePdfFld);
		row.add(btnPdfLookup);
		
		row = this.nextRow(FlowLayout.CENTER);
		row.add(pageBtn);
		row.add(previewSaveBtn);
		row.add(saveBtn);
		//row.add(savePDFoldBtn);
		row.add(makePDFbutton());
	}

   JButton makePDFbutton()
   {
		JButton savePDFBtn = new JButton("Save to PDF");
		savePDFBtn.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent ae)
			{
				Runnable runMe = new Runnable()
				{
					public void run()
					{
						printIText(); 
					}
				};
				new Thread(runMe).start();	
			}
		});
		return savePDFBtn;
   }
	  
	void printIText()
	{
		PageLayout pl = getSavedPageLayout();
    	try
     	{
    		ContactSheetDisplay.DisplayInfo info = SavePanel.this.display.getDisplayInfo(pl, false, false);
     	  	new ContactSheetPDF(
	    			info.fileList, 
	    			info.showFilesNotDirectories, 
	    			info.pageLayout, 
	    			info.headerFooterInfo, 
	    			info.contactSheetInfo, 
					SavePanel.this.display.getFileToSavePDFto(), 
					SavePanel.this.display.myFrame, 
					SavePanel.this.display.filePanel.myPageBar);
     	  	this.display.otherPanel.display(this.display.getFileToSavePDFto()); 
     	}
     	catch(Exception ex)
     	{
     		ex.printStackTrace();
			JOptionPane.showMessageDialog(SavePanel.this.display.myFrame, ex.getMessage(), Jibs.getString("problem"), JOptionPane.ERROR_MESSAGE);
     	}  			
	}
	
	SaveInfo getSaveInfo() throws Exception
	{
		File saveDirectory = new File(this.mySaveDirFld.getText());
		String fileNamePattern = this.myNameFld.getText();
		SaveInfo rtnMe = new SaveInfo(saveDirectory, fileNamePattern);
		return rtnMe;
	}

	private static final String CT_SAVE_DIRECTORY = "directory"; //$NON-NLS-1$
	private static final String CT_SAVE_NAME = "name"; //$NON-NLS-1$
   private static final String STORE_PDF_FILE_NAME = "save_pdf_file_name"; //$NON-NLS-1$

	void lookupPreferences()
	{
		this.mySaveDirFld.setText(this.display.myPrefs.get(CT_SAVE_DIRECTORY,
				System.getProperty("user.home"))); //$NON-NLS-1$
		this.myNameFld.setText(this.display.myPrefs.get(CT_SAVE_NAME, "idx")); //$NON-NLS-1$
		this.mySavePdfFld.setText(this.display.myPrefs.get(STORE_PDF_FILE_NAME, 
				System.getProperty("user.home") + 
				System.getProperty("file.separator") +				
				"jibs.pdf")); //$NON-NLS-1$
	}

	void savePreferences()
	{
		this.display.myPrefs.put(CT_SAVE_DIRECTORY, this.mySaveDirFld.getText());
		this.display.myPrefs.put(CT_SAVE_NAME, this.myNameFld.getText());
      this.display.myPrefs.put(STORE_PDF_FILE_NAME, this.mySavePdfFld.getText());    
	}

	// **************************************************************************
	// PREFERENCES
	// **************************************************************************
   private static final String STORE_PAGE_WIDTH = "save_page_width"; //$NON-NLS-1$
   private static final String STORE_PAGE_HEIGHT = "save_page_height"; //$NON-NLS-1$
   private static final String STORE_X = "save_store_x"; //$NON-NLS-1$
   private static final String STORE_Y = "save_store_y"; //$NON-NLS-1$
   private static final String STORE_WIDTH = "save_store_width"; //$NON-NLS-1$
   private static final String STORE_HEIGHT = "save_store_height"; //$NON-NLS-1$
	
   void saveLayout(PageLayout layout)
   {
		this.display.saveOptions();		
      this.display.myPrefs.putInt(STORE_X, layout.getInteriorLayout().getLeftMargin());
      this.display.myPrefs.putInt(STORE_Y, layout.getInteriorLayout().getTopMargin());
      this.display.myPrefs.putInt(STORE_WIDTH, layout.getInteriorLayout().getWidth());
      this.display.myPrefs.putInt(STORE_HEIGHT, layout.getInteriorLayout().getHeight());
      this.display.myPrefs.putInt(STORE_PAGE_WIDTH, layout.getPageWidth());
      this.display.myPrefs.putInt(STORE_PAGE_HEIGHT, layout.getPageHeight());    
      try{this.display.myPrefs.flush();}catch(Exception ex){ex.printStackTrace();}
   }	

   PageLayout getSavedPageLayout()
   {
   	//HKEY_CURRENT_USER\Software\JavaSoft\Prefs
   	PageLayout defaultLayout = PageLayout.makeDefault();
   	int pageWidth = this.display.myPrefs.getInt(STORE_PAGE_WIDTH, defaultLayout.getPageWidth());
   	int pageHeight = this.display.myPrefs.getInt(STORE_PAGE_HEIGHT, defaultLayout.getPageHeight());
   	int left = this.display.myPrefs.getInt(STORE_X, defaultLayout.getInteriorLayout().getLeftMargin());
   	int top = this.display.myPrefs.getInt(STORE_Y, defaultLayout.getInteriorLayout().getTopMargin());
   	int usableWidth = this.display.myPrefs.getInt(STORE_WIDTH, defaultLayout.getInteriorLayout().getWidth());
   	int usableHeight = this.display.myPrefs.getInt(STORE_HEIGHT, defaultLayout.getInteriorLayout().getHeight());  
   	return PageLayout.makeDPI(pageWidth, pageHeight, left, top, usableWidth, usableHeight);
   }   
}
