/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.jibs.viewer.frame;

import java.io.File;

import org.gerhardb.jibs.viewer.ViewerPreferences;
import org.gerhardb.lib.dirtree.ITreePopupMenu;
import org.gerhardb.lib.dirtree.rdp.ListShowTreeCoordinator;
import org.gerhardb.lib.util.Range;
import org.gerhardb.lib.util.startup.AppStarter;


public class LSTX extends ListShowTreeCoordinator
{
	SortScreen mySortScreen;
	
	public LSTX(SortScreen ss, ITreePopupMenu getter)
	{
		super(ss);
		this.mySortScreen = ss;
		super.init(getter);		
	}
	
	@Override
	public Range showingIndexes()
	{
		return this.mySortScreen.myShow.showingIndexes();
	}
	
   @Override
	public boolean isFullScreen()
   {
   	return this.mySortScreen.isFullScreen();
   }   
	
	@Override
	public void fileListUpdated()
	{
		this.mySortScreen.mySlideShowManager.setSlideShowButtons(true);
	}

   // Put park and delete under My Pictures/jibs/.
	@Override
	public String getDirectoryForParkAndDelete()
	{
		return AppStarter.getMyPicturesDir().getAbsoluteFile() + ViewerPreferences.JIBS_DIR_NAME;
	}


	@Override
	public String getPreference(String lookup, String aDefault)
	{
		return ViewerPreferences.getPrefs().get(lookup, null);
	}

	@Override
	public void removePreference(String lookup)
	{
		ViewerPreferences.getPrefs().remove(lookup);		
	}

	@Override
	public void undid(File file){ this.mySortScreen.myShow.jumpTo(file); }

}