/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.jibs.viewer.frame;

import java.awt.Cursor;
import org.gerhardb.jibs.viewer.ViewerPreferencesDialog;
import org.gerhardb.lib.dirtree.rdp.PathManager;

// import javax.swing.plaf.synth.*;

/**
 * Utility holding various popups.
 */
public class Popups
{
	SortScreen mySortScreen;
	
	// ==========================================================================
	// Constructor
	// ==========================================================================
	public Popups(SortScreen ss)
	{
		this.mySortScreen = ss;
	}
		
	void showSetup(int tabIndex)
	{
		this.mySortScreen.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
		String oldViewDirectory = this.mySortScreen.getLST().getPathManager().getDirectoryAbsolute(PathManager.DIR_TREE);
		try
		{
			new ViewerPreferencesDialog(this.mySortScreen, tabIndex);
		}
		finally
		{
			this.mySortScreen.setCursor(Cursor.getDefaultCursor());
		}

		// Show the changes
		try
		{
			String updatedTreeDir = this.mySortScreen.getLST().getPathManager().getDirectoryAbsolute(PathManager.DIR_TREE);
			if (oldViewDirectory == null
					|| (!oldViewDirectory.equals(updatedTreeDir)))
			{
				this.mySortScreen.getTreeManager().loadSavedTreeDirectory(updatedTreeDir);
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
	}
}
