/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.jibs.viewer.frame;

import javax.swing.border.BevelBorder;
import javax.swing.event.*;
import javax.swing.*;

import java.awt.*;
import java.text.DecimalFormat;


public class SelectedItemCountListener implements ListSelectionListener
{
	JList myList;
	int myCurrentCount;
	JLabel myLabel = new JLabel("  0 selected  ");
	Color myDefaultBackgroundColor = this.myLabel.getBackground();
   DecimalFormat myFormatter = new DecimalFormat();
   JButton myButton;
	
	SelectedItemCountListener(JList list, JButton button)
	{
		this.myList = list;
		this.myButton = button;
		this.myList.addListSelectionListener(this);
		this.myLabel.setToolTipText("Displays the number of items selected");
		this.myLabel.setOpaque(true);
		this.myLabel.setBorder(new BevelBorder(BevelBorder.LOWERED));
		this.myButton.setEnabled(false);
	}
	
	public void valueChanged(ListSelectionEvent e)
	{
		int count = this.myList.getSelectedIndices().length;
		if (this.myCurrentCount != count)
		{
			this.myCurrentCount = count;
			this.myLabel.setText("  " + this.myFormatter.format(this.myCurrentCount) + " selected" + "  ");
			if (this.myCurrentCount == 0)
			{
				this.myButton.setEnabled(false);
				this.myLabel.setBackground(this.myDefaultBackgroundColor);
				//myLabel.setForeground(Color.black);
			}
			else
			{
				this.myButton.setEnabled(true);
				this.myLabel.setBackground(Color.cyan);		
				//myLabel.setForeground(Color.yellow);		
			}
		}
	}
	
	JLabel getToolBarLabel()
	{
		return this.myLabel;
	}
}