/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.jibs.viewer.frame;

import javax.swing.Action;
import javax.swing.JButton;
import org.gerhardb.jibs.Jibs;
import org.gerhardb.lib.scroller.SlideShowListener;
import org.gerhardb.lib.util.Icons;

/**
 * Utility performing various actions.
 */
public class SlideShowManager
{
	SortScreen mySortScreen;

	JButton myFullScreenBtn;
	JButton myFullScreenSlideShowBtn;
	JButton mySlideShowBtn;
	// ==========================================================================
	// Constructor
	// ==========================================================================
	public SlideShowManager(SortScreen ss)
	{
		this.mySortScreen = ss;
		this.myFullScreenBtn = this.mySortScreen.myActions.getToolBarButton("view", "full"); //$NON-NLS-1$ //$NON-NLS-2$
		this.myFullScreenSlideShowBtn = this.mySortScreen.myActions.getToolBarButton("view", "fullmovie"); //$NON-NLS-1$ //$NON-NLS-2$
		this.mySlideShowBtn = this.mySortScreen.myActions.getToolBarButton("view", "movie"); //$NON-NLS-1$ //$NON-NLS-2$
	}

	// ==========================================================================
	// Public
	// ==========================================================================	
	public JButton getFullScreenButton()
	{
		return this.myFullScreenBtn;
	}
	
	public JButton getFullScreenSlideShowButton()
	{
		return this.myFullScreenSlideShowBtn;
	}
	
	public JButton getSlideShowButton()
	{
		return this.mySlideShowBtn;
	}
	
	// ==========================================================================
	// Package
	// ==========================================================================
	void setSlideShowButtons(boolean enabled)
	{
		this.myFullScreenBtn.setEnabled(enabled);
		this.myFullScreenSlideShowBtn.setEnabled(enabled);
		this.mySlideShowBtn.setEnabled(enabled);
	}

	void flipSlideShow()
	{
		// Button at top changed in slide show listener.
		if (this.mySortScreen.getScroller().isSlideShowRunning())
		{
			this.mySortScreen.getScroller().stopSlideShow();
			String resourseKey = "SortScreen.menu.view.movie.label"; //$NON-NLS-1$
			String retrieved = Jibs.getString(resourseKey);			
			this.mySlideShowBtn.getAction().putValue(Action.NAME, retrieved);
			this.mySlideShowBtn.setText(null);
		}
		else
		{
			this.mySortScreen.myShow.startSlideShow();
			String resourseKey = "SortScreen.menu.view.movie.stop"; //$NON-NLS-1$
			String retrieved = Jibs.getString(resourseKey);
			this.mySlideShowBtn.getAction().putValue(Action.NAME, retrieved);
			this.mySlideShowBtn.setText(null);
		}		
	}
	
	void setupSlideShowListener()
	{
		this.mySortScreen.getScroller().addSlideShowListener(new SlideShowListener()
		{
			public void slideShow(boolean running)
			{
				if (running)
				{
					SlideShowManager.this.mySlideShowBtn.setIcon(Icons.getIcon(Icons.STOP_MOVIE));
					SlideShowManager.this.mySlideShowBtn.setToolTipText(Jibs.getString("MovieManager.8")); //$NON-NLS-1$
				}
				else
				{
					SlideShowManager.this.mySlideShowBtn.setIcon(Icons.getIcon(Icons.MOVIE));
					SlideShowManager.this.mySlideShowBtn.setToolTipText(Jibs.getString("MovieManager.9")); //$NON-NLS-1$
				}
			}

		});
	}
	
	// ==========================================================================
	// Private
	// ==========================================================================

}
