/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.jibs.viewer.shows.classic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;

import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.viewer.IFrame;
import org.gerhardb.lib.swing.SwingUtils;

/**
 * NoResizeOptionsDialog
 */
public class NoResizeOptionsDialog extends JDialog
{
	NoResizeOptions myOptions = new NoResizeOptions();
	PadButton[] buttonPad = new PadButton[9];
	int myOriginalOption = this.myOptions.getFullSizeTileTo();
	int mySelectedOption = this.myOptions.getFullSizeTileTo();
	IFrame myFrame;

	/**
	 * @throws SecurityException
	 */
	public NoResizeOptionsDialog(IFrame frame)
	{
		super(frame.getFrame(), Jibs.getString("NoResizeOptionsDialog.0"), false); //$NON-NLS-1$
		this.myFrame = frame;
		this.buttonPad[0] = new PadButton(Jibs.getString("NoResizeOptionsDialog.1"), //$NON-NLS-1$
				NoResizeOptions.FULL_SIZE_UPPER_LEFT);
		this.buttonPad[1] = new PadButton(Jibs.getString("NoResizeOptionsDialog.2"), //$NON-NLS-1$
				NoResizeOptions.FULL_SIZE_UPPER_CENTER);
		this.buttonPad[2] = new PadButton(Jibs.getString("NoResizeOptionsDialog.3"), //$NON-NLS-1$
				NoResizeOptions.FULL_SIZE_UPPER_RIGHT);
		this.buttonPad[3] = new PadButton(Jibs.getString("NoResizeOptionsDialog.4"), //$NON-NLS-1$
				NoResizeOptions.FULL_SIZE_CENTER_LEFT);
		this.buttonPad[4] = new PadButton(Jibs.getString("NoResizeOptionsDialog.5"), //$NON-NLS-1$
				NoResizeOptions.FULL_SIZE_CENTER_CENTER);
		this.buttonPad[5] = new PadButton(Jibs.getString("NoResizeOptionsDialog.6"), //$NON-NLS-1$
				NoResizeOptions.FULL_SIZE_CENTER_RIGHT);
		this.buttonPad[6] = new PadButton(Jibs.getString("NoResizeOptionsDialog.7"), //$NON-NLS-1$
				NoResizeOptions.FULL_SIZE_LOWER_LEFT);
		this.buttonPad[7] = new PadButton(Jibs.getString("NoResizeOptionsDialog.8"), //$NON-NLS-1$
				NoResizeOptions.FULL_SIZE_LOWER_CENTER);
		this.buttonPad[8] = new PadButton(Jibs.getString("NoResizeOptionsDialog.9"), //$NON-NLS-1$
				NoResizeOptions.FULL_SIZE_LOWER_RIGHT);
		initLayout();
		for (int i = 0; i < this.buttonPad.length; i++)
		{
			this.buttonPad[i].showSelection();
		}
		
	}

	// ===========================================================================
	// Menu item to display the dialog
	// ===========================================================================
	/**
	 * Makes a new set for each UI its used on.
	 * 
	 * @return Sort Menu
	 */
	public static JMenuItem makeNoResizePreferenceMenu(final IFrame frame)
	{
		class NoResizePreferencesAction extends AbstractAction
		{
			NoResizePreferencesAction()
			{
				super(Jibs.getString("NoResizeOptionsDialog.10")); //$NON-NLS-1$
			}

			public void actionPerformed(ActionEvent event)
			{
				new NoResizeOptionsDialog(frame);
			}
		}

		return new JMenuItem(new NoResizePreferencesAction());
	}

	// ===========================================================================
	// The dialog
	// ===========================================================================
	private void initLayout()
	{
		JButton saveBtn = new JButton(Jibs.getString("save")); //$NON-NLS-1$
		saveBtn.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent ae)
			{
				// This is what's already set and showing.
				NoResizeOptionsDialog.this.dispose();
			}
		});

		JButton cancelBtn = new JButton(Jibs.getString("cancel")); //$NON-NLS-1$
		cancelBtn.addActionListener(new java.awt.event.ActionListener()
		{
			public void actionPerformed(java.awt.event.ActionEvent ae)
			{
				// Revert to original.
				NoResizeOptionsDialog.this.myOptions.setFullSizeTileTo(NoResizeOptionsDialog.this.myOriginalOption);
		        NoResizeOptionsDialog.this.myFrame.gotoRegularScreen();
				NoResizeOptionsDialog.this.dispose();
			}
		});

		JPanel okPanel = new JPanel(new FlowLayout(FlowLayout.CENTER));
		okPanel.add(saveBtn);
		okPanel.add(cancelBtn);
		

		JPanel buttonPanel = new JPanel(new GridLayout(3, 3, 2, 2));
		for (int i = 0; i < this.buttonPad.length; i++)
		{
			buttonPanel.add(this.buttonPad[i]);
		}

		JPanel basePanel = new JPanel(new BorderLayout());
		basePanel.add(buttonPanel, BorderLayout.CENTER);
		basePanel.add(okPanel, BorderLayout.SOUTH);

		super.setContentPane(basePanel);
		super.pack();
		SwingUtils.centerOnScreen(this);
		super.setVisible(true);
		saveBtn.requestFocus();
	}


	class PadButton extends JButton
	{
		int buttonOption;

		PadButton(String label, int option)
		{
			super(label);
			this.buttonOption = option;

			super.addActionListener(new ActionListener()
			{
				public void actionPerformed(ActionEvent ae)
				{
					NoResizeOptionsDialog.this.mySelectedOption = PadButton.this.buttonOption;
					for (int i = 0; i < NoResizeOptionsDialog.this.buttonPad.length; i++)
					{
						NoResizeOptionsDialog.this.buttonPad[i].showSelection();
					}
					NoResizeOptionsDialog.this.myOptions.setFullSizeTileTo(NoResizeOptionsDialog.this.mySelectedOption);
			      NoResizeOptionsDialog.this.myFrame.gotoRegularScreen();
				}
			});
		}
		
		void showSelection()
		{
			if (this.buttonOption == NoResizeOptionsDialog.this.mySelectedOption)
			{
				super.setBackground(Color.pink);
			}
			else
			{
				super.setBackground(Color.gray);
			}
		}
	}
}
