/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.jibs.viewer.shows.classic;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceListener;
import java.io.File;
import java.util.ArrayList;
import org.gerhardb.jibs.viewer.IFrame;
import org.gerhardb.lib.dirtree.filelist.LinklessDragListener;
import org.gerhardb.lib.scroller.IScroll;

/**
 * JPanel implementation of showing a single image.
 */
public class SingleDrag implements Transferable
{
	// -------------------- Things I create Initialized -------------------------
	public static final DataFlavor SINGLE_DRAG_DATA_FLAVOR = new
   DataFlavor(DataFlavor.javaJVMLocalObjectMimeType +
           "; class=org.gerhardb.jibs.viewer.shows.classic.SingleDrag", //$NON-NLS-1$
           "Local SinglDrag"); //$NON-NLS-1$
	protected DataFlavor[] myDataFlavors = 
	{ DataFlavor.javaFileListFlavor, SINGLE_DRAG_DATA_FLAVOR };
	IFrame myTopFrame;


	// ==========================================================================
	// Constructor
	// ==========================================================================
	public SingleDrag(Component comp, IFrame frame)
	{
		this.myTopFrame = frame;
		//System.out.println("SingleDrag created");
		DragSource ds = new DragSource();
		DragSourceListener dsl = new DSListener();
		DragGestureListener dgl =  
			new LinklessDragListener(dsl, this, ds);
		ds.createDefaultDragGestureRecognizer(
				comp,
				DnDConstants.ACTION_COPY_OR_MOVE, 
				dgl);
	}
	
	public File getFileToTransfer()
	{
		//System.out.println("SingleDrag returning File");
		return this.myTopFrame.getScroller().getCurrentFile();
	}

	// ===========================================================================
	// Transferable Implementation
	// ===========================================================================

	/**
	 * This is called from a drop.
	 */
	public Object getTransferData(DataFlavor flavor)
	{
		//System.out.println("SingleNoResize getTransferData!!!!!!!");
		if (DataFlavor.javaFileListFlavor.equals(flavor))
		{
			ArrayList<File> fileList = new ArrayList<File>(1);
			fileList.add(getFileToTransfer()); 
			return new ArrayList<File>(fileList);
		}
		else if (SINGLE_DRAG_DATA_FLAVOR.equals(flavor))
		{
			//System.out.println("Returning LOCAL Flavor"); //$NON-NLS-1$
			return this;
		}
		else
		{
			return null;
		}
		/* april 19 2007
		else
		{
			return this;
		}*/
	}

	public DataFlavor[] getTransferDataFlavors()
	{
		//System.out.println("SingleDrag returning Data Flavors");
		return this.myDataFlavors;
	}

	public boolean isDataFlavorSupported(DataFlavor flavor)
	{
		for (int i = 0; i < this.myDataFlavors.length; i++)
		{
			if (this.myDataFlavors[i].equals(flavor)) { return true; }
		}
		return false;
	}

	// ==========================================================================
	// DragSourceListener
	// ==========================================================================
	class DSListener extends DragSourceAdapter
	{
		/**
		 * This is where we find out the drag worked!!!!
		 */
		@Override
		public void dragDropEnd(DragSourceDropEvent event)
		{
			//Object source = ((DragSourceContext)event.getSource()).getComponent();
			//System.out.println("SingleDrag.Source: " + source);
			//System.out.println("SingleDrag.event.getDragSourceContext(): " + event.getDragSourceContext());
			
			// Needed for drags TO Windows File Manager.
			// Not needed for drags FROM Window File Manager.
			
			// KLUDGE because we ONLY want to do this if from Windows!!
			if (event.getDropSuccess())
				//if (source instanceof DragSourceContext)
			{
		        EventQueue.invokeLater(new Runnable()
		         {
		            public void run()
		            {
		   				//System.out.println("SingleDrag reloading");
		   				int returnToIndex = SingleDrag.this.myTopFrame.getScroller().getValueZeroBased();
							SingleDrag.this.myTopFrame.getFrame().setCursor(Cursor.getPredefinedCursor( Cursor.WAIT_CURSOR ));
							SingleDrag.this.myTopFrame.getScroller().reloadScroller(returnToIndex, IScroll.KEEP_CACHE); 
							SingleDrag.this.myTopFrame.getFrame().setCursor(Cursor.getPredefinedCursor( Cursor.DEFAULT_CURSOR ));
		            }
		         });					
			}
 		}
		
		@Override
		public void dropActionChanged(DragSourceDragEvent event)
		{
			//System.out.println( "SingleDrag.dropActionChanged" );
			switch ( event.getUserAction())
			{
			case DnDConstants.ACTION_MOVE:
				//System.out.println("SingleDrag Accepting Drop: MOVE");
				event.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
				break;
			case DnDConstants.ACTION_COPY:
				//System.out.println("SingleDrag Accepting Drop: COPY");
				event.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
				break;
			default:		
			}
		}
		/*
		 public void dragEnter(DragSourceDragEvent dsde)
		 {
		 System.out.println("ScrolledSlider.dragEnter");
		 }

		 public void dragExit(DragSourceEvent dse)
		 {
		 System.out.println("ScrolledSlider.dragExit");
		 }

		 public void dragOver(DragSourceDragEvent dsde)
		 {
		 //System.out.println( "ScrolledSlider.dragOver" );
		 }

		 */
		
		/*  OBSOLETE MAY 7, 2006
		//System.out.println("ScrolledDipslayCoordinator.dragDropEnd");
		// Don't remove for just a copy!
		if (event.getDropSuccess())
		{
			//System.out.println("DROP SUCCESS!!!!");
			if (DnDConstants.ACTION_MOVE == event.getDropAction())
			{
				//System.out.println("Drop Success - DROP ACTION A MOVE!!");
				//myTopFrame.getScroller().removeCurrentPage();
			}
		}
		else
		{
			// Windows does not report success even when it works!
			//System.out.println("mayberemoveCurrentPage");
			File oldItem = myTopFrame.getScroller().getCurrentFile();
			if (oldItem != null && !oldItem.exists())
			{
				//myTopFrame.getScroller().removeCurrentPage();
			}
		}
		 */
	}	
}
