/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.jibs.viewer.shows.classic;

// Caveat programmer: you should replace this with a JMF equivalent when that's
// ready for all of your delivery platforms.
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import javax.swing.JMenuItem;

import org.gerhardb.jibs.viewer.IFrame;

/**
 * JPanel implementation of showing a single image.
 */
abstract public class SingleNoResize extends Single
{
	NoResizeOptions myOptions = new NoResizeOptions(); 
	float					myOffsetWidthPercentage;
	float					myOffsetHeightPercentage;
	boolean iNeedToRepositionScrollBars = false;

	// ==========================================================================
	// Constructor
	// ==========================================================================
	public SingleNoResize(IFrame mf)
	{
		// Set up double buffered
		super(mf);

		// Set up key events
		KeyListener adapter = getKeyListener();
		super.addKeyListener(adapter);
		this.myViewerFrame.getScroller().setShowViewKeyListener(adapter);
   	this.myViewerFrame.getScroller().setEndMessages(true);
	}

	abstract KeyListener getKeyListener();
	
	// ==========================================================================
	// IShow Implemenation
	// ==========================================================================

	public JMenuItem makePreferencesItem()
	{
		return NoResizeOptionsDialog.makeNoResizePreferenceMenu(this.myViewerFrame);
	}

	/**
	 * Shows the picture.
	 */
	public void showImage()
	{
		switch (this.myOptions.getFullSizeTileTo())
		{
		case NoResizeOptions.FULL_SIZE_UPPER_LEFT:
			this.myOffsetHeightPercentage = 0.0f;
			this.myOffsetWidthPercentage = 0.0f;
			break;
		case NoResizeOptions.FULL_SIZE_UPPER_CENTER:
			this.myOffsetHeightPercentage = 0.0f;
			this.myOffsetWidthPercentage = 0.5f;
			break;
		case NoResizeOptions.FULL_SIZE_UPPER_RIGHT:
			this.myOffsetHeightPercentage = 0.0f;
			this.myOffsetWidthPercentage = 1.0f;
			break;
		case NoResizeOptions.FULL_SIZE_CENTER_LEFT:
			this.myOffsetHeightPercentage = 0.5f;
			this.myOffsetWidthPercentage = 0.0f;
			break;
		case NoResizeOptions.FULL_SIZE_CENTER_CENTER:
			this.myOffsetHeightPercentage = 0.5f;
			this.myOffsetWidthPercentage = 0.5f;
			break;
		case NoResizeOptions.FULL_SIZE_CENTER_RIGHT:
			this.myOffsetHeightPercentage = 0.5f;
			this.myOffsetWidthPercentage = 1.0f;
			break;
		case NoResizeOptions.FULL_SIZE_LOWER_LEFT:
			this.myOffsetHeightPercentage = 1.0f;
			this.myOffsetWidthPercentage = 0.0f;
			break;
		case NoResizeOptions.FULL_SIZE_LOWER_CENTER:
			this.myOffsetHeightPercentage = 1.0f;
			this.myOffsetWidthPercentage = 0.5f;
			break;
		case NoResizeOptions.FULL_SIZE_LOWER_RIGHT:
			this.myOffsetHeightPercentage = 1.0f;
			this.myOffsetWidthPercentage = 1.0f;
			break;
		}
		
		// Need to do during paint because kicking scroll bars during paint causes them to resize.
		this.iNeedToRepositionScrollBars = true;
		repaint();
		/*
		 * // RUNNING TO ERRATICALLY FOR MOMENT. SwingUtilities.invokeLater(new
		 * Runnable() { public void run() { centerPicture(); } });
		 */
	}

	// ==========================================================================
	// Inner Classes
	// ==========================================================================

	void processNumPad(KeyEvent event)
	{
		if (event.isAltDown())
		{
			switch (event.getKeyCode())
			{
			case KeyEvent.VK_NUMPAD1:
				event.consume();
				this.myOptions.setFullSizeTileTo(NoResizeOptions.FULL_SIZE_LOWER_LEFT);
				showImage();
				return;
			case KeyEvent.VK_NUMPAD2:
				event.consume();
				this.myOptions.setFullSizeTileTo(NoResizeOptions.FULL_SIZE_LOWER_CENTER);
				showImage();
				return;
			case KeyEvent.VK_NUMPAD3:
				event.consume();
				this.myOptions.setFullSizeTileTo(NoResizeOptions.FULL_SIZE_LOWER_RIGHT);
				showImage();
				return;
			case KeyEvent.VK_NUMPAD4:
				event.consume();
				this.myOptions.setFullSizeTileTo(NoResizeOptions.FULL_SIZE_CENTER_LEFT);
				showImage();
				return;
			case KeyEvent.VK_NUMPAD5:
				event.consume();
				this.myOptions.setFullSizeTileTo(NoResizeOptions.FULL_SIZE_CENTER_CENTER);
				showImage();
				return;
			case KeyEvent.VK_NUMPAD6:
				event.consume();
				this.myOptions.setFullSizeTileTo(NoResizeOptions.FULL_SIZE_CENTER_RIGHT);
				showImage();
				return;
			case KeyEvent.VK_NUMPAD7:
				event.consume();
				this.myOptions.setFullSizeTileTo(NoResizeOptions.FULL_SIZE_UPPER_LEFT);
				showImage();
				break;
			case KeyEvent.VK_NUMPAD8:
				event.consume();
				this.myOptions.setFullSizeTileTo(NoResizeOptions.FULL_SIZE_UPPER_CENTER);
				showImage();
				return;
			case KeyEvent.VK_NUMPAD9:
				event.consume();
				this.myOptions.setFullSizeTileTo(NoResizeOptions.FULL_SIZE_UPPER_RIGHT);
				showImage();
				return;
			}
		}
	}
}
