/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.jibs.viewer.shows.classic;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.io.File;

import javax.swing.JMenuItem;
import org.gerhardb.jibs.viewer.IFrame;
import org.gerhardb.jibs.viewer.sorter.TilePanel;
import org.gerhardb.lib.image.ImageChangeUtil;

/**
 * JPanel implementation of showing a single image.
 */
public class SingleResize extends Single
{
	static private final Color	RESIZE_COLOR			= Color.red;	

	// ==========================================================================
	// Constructor
	// ==========================================================================
	public SingleResize(IFrame mf)
	{
		// Set up double buffered
		super(mf);
				
		// Set up key events
		KeyAdapter adapter = new KeyAdapter()
		{
			@Override
			public void keyReleased(KeyEvent event)
			{
				//System.out.println("SingleResize keyReleased: event.getKeyCode(): " + event.getKeyCode() + "  KEY: " + KeyEvent.getKeyText(event.getKeyCode()));
				switch (event.getKeyCode())
				{
				case KeyEvent.VK_F2:
					SingleResize.this.myViewerFrame.gotoFullScreen(false);
					event.consume();
					return;
				}
			}
			
	        @Override
			public void keyPressed(KeyEvent event)
	         {
					//System.out.println("SingleResize keyPressed: event.getKeyCode(): " + event.getKeyCode() + "  KEY: " + KeyEvent.getKeyText(event.getKeyCode()));
					switch (event.getKeyCode())
					{
					case KeyEvent.VK_ENTER:
						if ((event.getModifiersEx() & InputEvent.CTRL_DOWN_MASK) == InputEvent.CTRL_DOWN_MASK)
						{
							revert();
						}
						if ((event.getModifiersEx() & InputEvent.ALT_DOWN_MASK) == InputEvent.ALT_DOWN_MASK)
						{
							revert();
						}
						event.consume();
						return;
					}
	         }
			
		};
		super.addKeyListener(adapter);	
		this.myViewerFrame.getScroller().setShowViewKeyListener(null);	
		
   	this.myViewerFrame.getScroller().setEndMessages(true);
	}

   // ==========================================================================
	// Overridden methods
	// ==========================================================================
	@Override
	protected boolean iCanResize()
	{
		return false;
	}
	
	//public void paint(Graphics g)
	@Override
	public void showImage(Graphics g)
   {
   	// Apparently, background color can only be set once per draw without
   	// confusing SWING.
   	Color backgroundColor = OK_COLOR; // DEFAULT COLOR
		
		BufferedImage showMe = this.mySaver.getCurrentImage();
		if (showMe == null)
		{
			showMe = this.myViewerFrame.getScroller().getBeyondBounds();
			if (showMe == null) 
			{ 	
				super.showNoPicture(g);
				return; 
			}
			backgroundColor = EMPTY_COLOR;
		}

		//System.out.println("======================== showImage ============================");
		//System.out.println("Panel w h: " + super.getWidth() + " " + super.getHeight());
		//System.out.println("Raw Picture w h: " + showMe.getWidth() + " " + showMe.getHeight());		

   	// Resize
      BufferedImage originalImage = showMe;
		showMe = 
			ImageChangeUtil.fitAspectDown(
					showMe, 
					super.getWidth(), 
					super.getHeight());		
	
		// Check for resized color.
		if ( originalImage.getWidth() > showMe.getWidth() 
				|| originalImage.getHeight() > showMe.getHeight())
		{
			backgroundColor = RESIZE_COLOR;
		}
		
		//System.out.println("Sized Picture w h: " + showMe.getWidth() + " " + showMe.getHeight());		
      

      // Remember for pic info dialog
      this.myShownWidth = showMe.getWidth();
      this.myShownHeight = showMe.getHeight();
      
      // Now the the correct background color has been established,
      // use it.
		super.setBackground(backgroundColor); 
		super.paintComponent(g);  // First, fill with background color.
		
		Graphics2D g2 = (Graphics2D)g;
      
		// Figure out centering
		int centerWidth = ((super.getWidth() - showMe.getWidth()) / 2);
		if (centerWidth < 0)
		{
			centerWidth = 0;
		}
		
		int centerHeight = ((super.getHeight() - showMe.getHeight()) / 2);
		if (centerHeight < 0)
		{
			centerHeight = 0;
		}
		
		// Draw the new image
      g2.drawImage(showMe, null, centerWidth, centerHeight);
  
/* center picture if too big and not resized???      
      if (ViewerPreferences.getResizeOnFlyOverride())
      {
         Rectangle scrollTo = new Rectangle();

         Rectangle visible = myPicturePanel.getVisibleRect();
         System.out.println("============================================" );
         System.out.println("Visiable Height: " + visible.height );
         System.out.println("Visiable Width: " + visible.width );
         System.out.println("Image Height: " + mainIcon.getIconHeight() );
         System.out.println("Image Width: " + mainIcon.getIconWidth() );

         // See bottom for how to adjust for insets
         if (visible.height < mainIcon.getIconHeight())
         {
            int diff = mainIcon.getIconHeight() - visible.height;
            scrollTo.y = diff / 2;
            scrollTo.height = visible.height;
         }

         if (visible.width < mainIcon.getIconWidth())
         {
            int diff = mainIcon.getIconWidth() - visible.width;
            scrollTo.x = diff / 2;
            scrollTo.width = visible.width;
         }
         myPicturePanel.scrollRectToVisible(scrollTo);
      }
*/
      
      File file = this.myViewerFrame.getScroller().getCurrentFile();
      if (file != null)
      {
      	TilePanel.clsTilePanel.clip(file, g2, super.getWidth(), super.getHeight());
      }

      this.myViewerFrame.statusCurrentPage();      
   }
   
   // ==========================================================================
	// IShow Implemenation
	// ==========================================================================
	
	public JMenuItem makePreferencesItem()
	{
		return null;
	}

	/**
	 * Shows the picture.
	 */
	public void showImage()
	{	
		repaint();
	}
	

}
