package org.gerhardb.jibs.viewer.shows.comic;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;

import javax.swing.JComponent;

import org.gerhardb.jibs.viewer.ViewerPreferences;
import org.gerhardb.lib.image.ImageChangeUtil;

public class ThumbnailImage extends JComponent
{
	private float THUMBNAIL_PROPORTION_IN_FRAME = 0.9f;
   private int maxBlow = ViewerPreferences.getMaxBlow();
	private BufferedImage	myImage;

	/**
	 * Image for full screen.  
	 * Centers if bigger than screen.
	 */
	public ThumbnailImage()
	{
		super.setOpaque(true);
		super.setBackground(ComicScreen.BACKGROUND_COLOR);
	}

	// ========================================================================
	// Public Methods
	// ========================================================================
	public void setImage(BufferedImage image)
	{
		this.myImage = image;
		repaint();
	}
	
	// ==========================================================================
	// Overridden Methods
	// ==========================================================================

	@Override
	protected void paintComponent(Graphics graphics)
	{
		// Draw in our entire space, even if isOpaque is false.
		graphics.setColor(this.getBackground());
		graphics.fillRect(0, 0, getWidth(), getHeight());
		
		BufferedImage sizedImage = getSizedImage(this.myImage);		
		if (sizedImage != null)
		{
			int centerX = ((super.getWidth() - sizedImage.getWidth()) / 2);
			int centerY = ((super.getHeight() - sizedImage.getHeight()) / 2);
			graphics.drawImage(sizedImage, centerX, centerY, this);
		}
	}
	
	// ==========================================================================
	// Private Methods
	// ==========================================================================
	private BufferedImage getSizedImage(BufferedImage image)
	{
		if (image == null)
		{
			return image;
		}			
		
		// Let's see if we should do an on the fly resize.
		Rectangle clip = super.getVisibleRect();
		double clipWidth = clip.getWidth() * this.THUMBNAIL_PROPORTION_IN_FRAME;
		double clipHeight = clip.getHeight() * this.THUMBNAIL_PROPORTION_IN_FRAME;

		// See if there is actually anything to show.
		if (clipWidth == 0 && clipHeight == 0)
		{
			// Don't bother showing because nothing is visable.
			return null;
		}
		
		int imgWidth = image.getWidth();
		int imgHeight = image.getHeight();

		//System.out.println("ThumbnailImage: Full Screen Image: " + ViewerGlobals.gblScroller.getCurrentFile());
		//System.out.println("ThumbnailImage: Visible Region: w: " + clipWidth + " h: " + clipHeight );
		//System.out.println("ThumbnailImage: Image Real: w: " + imgWidth + " h: " + imgHeight );

		float thetaDown = ImageChangeUtil.calcThetaDown(imgWidth,
				imgHeight, clipWidth, clipHeight);
		if (thetaDown > 0 && thetaDown < 1.0)
		{
			//System.out.println("ThumbnailImage: SHRINKING");
			//System.out.println("ThumbnailImage: thetaDown: " + thetaDown);
			image = ImageChangeUtil.scale(image, thetaDown);
		}
		else
		{			
			float thetaUp = ImageChangeUtil.calcThetaUp(imgWidth,
					imgHeight, clipWidth, clipHeight);
			//System.out.println("GROWING");
			//System.out.println("ThumbnailImage: thetaUp: " + thetaUp);

			if (thetaUp > this.maxBlow)
			{
				image = ImageChangeUtil.scale(image, this.maxBlow);
				//System.out.println("ThumbnailImage: using max blow: " + maxBlow);
			}
			else if (thetaUp > 0)
			{
				image = ImageChangeUtil.scale(image, thetaUp);
			}
		}
		return image;
	}
}
