/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.jibs.viewer.shows.thumbs;

import java.util.prefs.Preferences;

/**
 * ThumbnailOptions
 */
public class ThumbnailOptions
{
	private static final String	PREF_PATH
		= "/org/gerhardb/jibs/viewer/ThumbnailPreferences"; //$NON-NLS-1$
	
	private Preferences myPrefs;
	Thumbnails myThumbnails;
	   
   /**
    * @throws SecurityException
    */
   public ThumbnailOptions(Thumbnails thumb)
   {
      this.myPrefs = Preferences.userRoot().node(PREF_PATH);
      this.myThumbnails = thumb;
   }

	// ===========================================================================
	// Needed to run Thumbnails
	// ===========================================================================
	private static final String	ROWS	= "rows"; //$NON-NLS-1$
	private static final String	COLS	= "cols"; //$NON-NLS-1$
	private static final String	PICK	= "SelectedPicCell"; //$NON-NLS-1$
	private static final String	PRELOAD	= "PreloadCount"; //$NON-NLS-1$

	public int getRows()
	{
		return this.myPrefs.getInt(ROWS, 3);
	}

	public void setRows(int rows)
	{
		this.myPrefs.putInt(ROWS, rows);
	}

	public int getCols()
	{
		return this.myPrefs.getInt(COLS, 3);
	}

	public void setCols(int rows)
	{
		this.myPrefs.putInt(COLS, rows);
	}

	public int getSelectedPicCell()
	{
		//	5 is middle of 9
		return this.myPrefs.getInt(PICK, 1);
	}

	public void setSelectedPicCell(int cell)
	{
		this.myPrefs.putInt(PICK, cell);
	}

	public int getPreloadCount()
	{
		return this.myPrefs.getInt(PRELOAD, 520);
	}

	public void setPreloadCount(int preload)
	{
		this.myPrefs.putInt(PRELOAD, preload);
		this.myThumbnails.myCache.setMaxPreload(preload);
	}
	 
}
