/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.jibs.viewer.shows.thumbs;

import java.awt.image.BufferedImage;
import org.gerhardb.lib.scroller.Scroller;
import org.gerhardb.lib.image.ImageChangeUtil;


/**
 * Stores any rotations user has made.
 */
class ThumbnailRotations
{
	int[] myRotations = new int[0];
	private Scroller myScroller;
	
	/**
	 * Creates the cache and starts it running.
	 */
	ThumbnailRotations(Scroller scroller)
	{
		this.myScroller = scroller;
	}
	
	// resetRotations(scroller.getSize());
	void resetRotations(int length)
	{
		this.myRotations = new int[length];
	}
	
	void addRotation(int index, int rotation)
	{
		//System.out.print("ThumbnailCache Index: " + index + " Unadjusted: " + this.myRotations[index]);		
		this.myRotations[index] = this.myRotations[index] + rotation;
		
		// Make sure range is from 0 to 360.
		while (this.myRotations[index] >= 360)
		{
			this.myRotations[index] = this.myRotations[index] - 360;
		}
		while (this.myRotations[index] < 0)
		{
			this.myRotations[index] = this.myRotations[index] + 360;
		}		
		//System.out.println("  Adjusted: " + this.myRotations[index]);
	}
	
	int getRotation(int index)
	{
		if (index < 0 || index >= this.myRotations.length)
		{
			return 0;
		}
		return this.myRotations[index];
	}
	
	void remove(int removeIndex)
	{
		int [] newRotations = new int[this.myScroller.getSize()];
		int newIndex = 0;
		for (int i = 0; i < newRotations.length; i++)
		{
			if (i != removeIndex)
			{
				newRotations[newIndex] = this.myRotations[i];
				newIndex++;
			}
		}
		this.myRotations = newRotations;		
	}
	
	// Accomodates both Thumbnails and actual image by passing the image in.
	BufferedImage getRotatedImage(int index, BufferedImage image)
	{
		if (!(index < this.myRotations.length))
		{
			return null;
		}
		// Fast escapes
		BufferedImage rtnMe = image;
		// In case picture is deleted from under this.
		if (rtnMe == null || index > this.myRotations.length)
		{
			return null;
		}
		
		int rotation = this.myRotations[index];
		
		// We need to do some actual work...
		switch (rotation)
		{
			case 0:
				return image;
			case 90:
			case -270:
				return ImageChangeUtil.rotateRight(image);
			case -90:
			case 270:
				return ImageChangeUtil.rotateLeft(image);
			case 180:
			case -180:
				return ImageChangeUtil.flip(image);
			default:
				return image;
		}		
	}
} 