/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.jibs.viewer.sorter;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.io.File;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

import org.gerhardb.jibs.viewer.ViewerPreferences;
import org.gerhardb.jibs.viewer.frame.SortScreen;

public class TilePanel extends JPanel
{		
	public static TilePanel clsTilePanel = new TilePanel();
	static int clsTileSize = ViewerPreferences.getSorterTileSize();
	static Dimension clsTileSizeDim = new Dimension(clsTileSize, clsTileSize);
	static SortScreen clsSortScreen;
	static JScrollBar clsHorizontalScrollBar;
	
	TilePanel()
	{
		super(new FlowLayout(FlowLayout.LEFT));
	}
	
	// =========================================================================
	// Override JPanel
	// =========================================================================
	
	// =========================================================================
	// Regular
	// =========================================================================
	
	public void clip(File file, Graphics2D g2, int width, int height)
	{
		if (isFileInList(file))
		{
			g2.setColor(Color.cyan);  // cyan  yellow
			
			BasicStroke stroke = new BasicStroke(4.0f);
			g2.setStroke(stroke);
			
			int southEast = height/6;
			int northWest = width - width/6;
			Polygon poly = new Polygon();
			poly.addPoint(width, 0);
			poly.addPoint(width, southEast);
			poly.addPoint(northWest, 0);
			g2.fillPolygon(poly);
		}
	}
	
	private boolean isFileInList(File testFile)
	{
		if (testFile == null){return false;}
		Component[] tiles = super.getComponents();
		for (int i = 0; i < tiles.length; i++)
		{
			File aFile = ((Tile)tiles[i]).myFile;
			if (testFile.equals(aFile))
			{
				return true;
			}
		}
		return false;
	}
	
	File[] getFiles()
	{
		Component[] tiles = super.getComponents();
		File[] rtnMe = new File[tiles.length];
		for (int i = 0; i < tiles.length; i++)
		{
			rtnMe[i] = ((Tile)tiles[i]).myFile;
		}
		return rtnMe;
	}

	void clearTiles()
	{
		removeAll();
		super.repaint();
	}

	void setTileSize(int size)
	{
		clsTileSize = size;
		clsTileSizeDim = new Dimension(clsTileSize, clsTileSize);
		File[] oldFiles = getFiles();
		clsTilePanel.removeAll();
		int position = 0;
		for (int i = 0; i < oldFiles.length; i++)
		{
			if (oldFiles[i] != null)
			{
				new Tile(position, oldFiles[i]);
				position++;
			}
		}
		new Tile();
		super.repaint();
	}	
}


/*
interface FileListener
{
	public void fileAdded(File file);
	
	public void fileRemoved(File file);
}


	ArrayList myFileListeners = new ArrayList(5);

	public Component add(Component comp)
	{
		throw new RuntimeException("TilePanel does not support this add.");
	}

	public Component add(String name,
                    Component comp)
	{
		throw new RuntimeException("TilePanel does not support this add.");
	}

	public Component add(Component comp, int index)
	{
		ChangingOneComponent(comp, ADD_COMPONENT);
		return super.add(comp, index);
	}

	public void add(Component comp,
               Object constraints)
	{
		throw new RuntimeException("TilePanel does not support this add.");
	}

	public void add(Component comp,
               Object constraints,
               int index)	
	{
		throw new RuntimeException("TilePanel does not support this add.");
	}
	
	public void remove(int index)
	{
		Component comp = getComponent(index);
		ChangingOneComponent(comp, REMOVE_COMPONENT);
		
		super.remove(index);		
	}
	
	public void remove(Component comp)
	{
		ChangingOneComponent(comp, REMOVE_COMPONENT);
		
		super.remove(comp);
	}
	
	public void removeAll()
	{
		FileListener[] listeners = null;
		synchronized (myFileListeners)
		{
			listeners = new FileListener[myFileListeners.size()];
			myFileListeners.toArray(listeners);
		}
		Component[] tiles = super.getComponents();
		for (int i = 0; i < tiles.length; i++)
		{
			if (tiles[i] != null && tiles[i] instanceof Tile)
			{
				File file = ((Tile)tiles[i]).myFile;
				if (file != null)
				{
					for (int j = 0; j < listeners.length; j++)
					{
						listeners[j].fileRemoved(file);
					}
				}
			}
		}
		
		super.removeAll();
	}

	// =========================================================================
	// FileListener
	// =========================================================================
	public void addFileListener(FileListener x)
	{
		synchronized (myFileListeners)
		{
			myFileListeners.add(x);
		}
	}

	public void removeFileListener(FileListener x)
	{
		synchronized (myFileListeners)
		{
			myFileListeners.remove(x);
		}
	}
	
	void ChangingOneComponent(Component comp, boolean add)
	{
		if (comp == null || !(comp instanceof Tile))
		{
			return;
		}
		Tile tile = (Tile)comp;
		File file = tile.myFile;
		if (file == null)
		{
			return;
		}
		
		Component[] tiles = super.getComponents();
		for (int i = 0; i < tiles.length; i++)
		{
			if (tiles[i] != null && tiles[i] instanceof Tile)
			{
				// Don't match for tile being removed.
				if (tiles[i] != tile && file.equals(((Tile)tiles[i]).myFile))
				{
					return;
				}
			}
		}
		
		FileListener[] listeners = null;
		synchronized (myFileListeners)
		{
			listeners = new FileListener[myFileListeners.size()];
			myFileListeners.toArray(listeners);
		}
		for (int i = 0; i < listeners.length; i++)
		{
			if (add)
			{
				System.out.println("ADDING A NEW UNIQUE FILE");
				listeners[i].fileAdded(file);
			}
			else
			{
				System.out.println("REMOVING LAST COPY OF A FILE");
				listeners[i].fileRemoved(file);
			}
		}
	}

*/