/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.jibs.viewer.tree;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;

import javax.swing.JMenuItem;
import javax.swing.tree.TreePath;

import org.gerhardb.jibs.Jibs;
import org.gerhardb.jibs.optimizer.Optimizer;
import org.gerhardb.lib.dirtree.*;

/**
 * Derived from code originally presented in
 * Core Swing Advanced Programming
 * by Kim Topley, Printice Hall PTR, chapter 8.
 */
public class FileTreePopUp
   extends ExtendedDirectoryTreePopUp
{
   // --------------------------------------------------------------------------
   //                           Constructor
   // --------------------------------------------------------------------------
   /**
    * @param tree popuped up on
    * @param path path
    */
   public FileTreePopUp(ExtendedDirectoryTree tree, TreePath path, boolean countImageFilesInNodes)
   {
      super(tree, path, countImageFilesInNodes);
   }
   
   @Override
	protected void addExtensions()
   {
      this.addSeparator();
      JMenuItem optimizeSingle = add(Jibs.getString("FileTreePopUp.8")); //$NON-NLS-1$
      JMenuItem optimizeTree = add(Jibs.getString("FileTreePopUp.9")); //$NON-NLS-1$
      JMenuItem optimizeSelected = add(Jibs.getString("FileTreePopUp.10")); //$NON-NLS-1$
      
      if (this.getDirectoryNode() == null)
      {
         optimizeSingle.setEnabled(false);
         return;
      }

      optimizeTree.setEnabled(false);      
      if (this.getDirectoryNode().getChildCount()>0)
      {
         optimizeTree.setEnabled(true);
      }
      
      optimizeSelected.setEnabled(false);
      if (this.getTree().getSelectionCount() > 0)
      {
         optimizeSelected.setEnabled(true);
      }      
      
      optimizeSingle.addActionListener(
         new ActionListener()
      {
         public void actionPerformed(ActionEvent event)
         {
            File[] file = new File[]{FileTreePopUp.this.getDirectoryNode().getFile()};
            new Optimizer(file, FileTreePopUp.this.getTree().getPlugins().getRDPplugins());
         }
      });

      optimizeTree.addActionListener(
         new ActionListener()
      {
         public void actionPerformed(ActionEvent event)
         {
            Enumeration<?> depth = FileTreePopUp.this.getDirectoryNode().depthFirstEnumeration();
            ArrayList<File> list = new ArrayList<File>();
            while(depth.hasMoreElements())
            {
               DirectoryTreeNode aNode = (DirectoryTreeNode)depth.nextElement();
               list.add(aNode.getFile());
            }
            File[] files = new File[list.size()];
            list.toArray(files);
            new Optimizer(files, FileTreePopUp.this.getTree().getPlugins().getRDPplugins());
         }
      });

      optimizeSelected.addActionListener(
         new ActionListener()
      {
         public void actionPerformed(ActionEvent event)
         {
            TreePath[] paths = FileTreePopUp.this.getTree().getSelectionPaths();
            File[] files = new File[paths.length];
            for( int i=0; i<paths.length; i++ )
            {
               DirectoryTreeNode aNode =
                  (DirectoryTreeNode)paths[i].getLastPathComponent();
               files[i] = aNode.getFile();
            }
            new Optimizer(files, FileTreePopUp.this.getTree().getPlugins().getRDPplugins());
         }
      });
   }
}
