/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.dirtree;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;

import org.gerhardb.lib.io.FilenameFileFilter;
import org.gerhardb.lib.io.FilesOnlyFileFilter;
import org.gerhardb.lib.scroller.ListMaker;

public class DTNListFactory
   implements ListMaker
{
   DirectoryTreeNode[] myNodes;
   boolean iShowNonImages;
   FilenameFileFilter myFilter;

   public DTNListFactory(DirectoryTreeNode[] nodes, boolean nonImage, FilenameFileFilter filter)
   {
      if (nodes == null || nodes.length == 0)
      {
         throw new IllegalArgumentException(
            "DTNListFactory requires non-null DirectoryTreeNode."); //$NON-NLS-1$
      }
      this.myNodes = nodes;
      this.iShowNonImages = nonImage;
      this.myFilter = filter;
   }

   public String getDescription()
   {
      switch(this.myNodes.length)
      {
         case 1:
            return this.myNodes[0].getAbsolutePath();
         case 2:
            return this.myNodes[0].getAbsolutePath()
               + " and " + this.myNodes[1].getAbsolutePath(); //$NON-NLS-1$
         default:
            return "Various directories selected"; //$NON-NLS-1$
      }
   }

   public File[] getFileList()
   {
      // Now do real work.
	   File[] fileList = null;
      ArrayList<DTNFile> pageList = new ArrayList<DTNFile>(400);
      for (int i = 0; i < this.myNodes.length; i++)
      {
         File directory = this.myNodes[i].getFile();
         if (this.iShowNonImages)
         {
         	fileList = directory.listFiles(FilesOnlyFileFilter.FILES_ONLY);         	
         }
         else
         {         	
         	fileList = directory.listFiles(this.myFilter); //ImageFactory.getImageFactory().getFilter());
         }
         if (fileList != null)
         {
	         for (int j = 0; j < fileList.length; j++)
	         {
	            pageList.add(
	            		new DTNFile(fileList[j].getAbsolutePath(), this.myNodes[i]));
	         }
         }
      }

      DTNFile[] pages = new DTNFile[pageList.size()];
      pageList.toArray(pages);

      return pages;
   }
   
   public boolean nodesUpdated(DirectoryTreeNode parent)
   {
	   boolean rtnMe = false;
       Enumeration<?> kids = parent.breadthFirstEnumeration();
       while (kids.hasMoreElements())
       {
          DirectoryTreeNode aNode =
             (DirectoryTreeNode)kids.nextElement();
          for( int i=0; i<this.myNodes.length; i++)
          {
        	  if ( this.myNodes[i].getDirectory().equals(aNode.getDirectory()) )
        	  {
        		  this.myNodes[i] = aNode;
        		  rtnMe = true;
        	  }
          }
       }	   
	   return rtnMe;
   }

}
