/*
 * Copyright (c) 2007 Gerhard Beck. All rights reserved.
 * 
 * Subject to the GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007
 * http://www.gnu.org/licenses/gpl.html
 * 
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL GERHARD
 * BECK OR OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package org.gerhardb.lib.dirtree;

import java.io.File;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

import org.gerhardb.lib.util.startup.ILoadingMessage;

/**
 * Utility performing various actions.
 */
public class DTNReaderWriter
{
	public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss"); //$NON-NLS-1$
	
	static final String DATE_MARKER = "# Date: "; //$NON-NLS-1$
	static final String VERSION_TOKEN_TARGET_COUNTED = "# v2i "; //$NON-NLS-1$
	static final String VERSION_TOKEN_NO_TARGET_COUNT = "# v2x "; //$NON-NLS-1$
	static final String ROOT_NAME_MARKER = "# Root Name: "; //$NON-NLS-1$
	static final String ROOT_PATH_MARKER = "# Root Path: "; //$NON-NLS-1$

	boolean iCountTargetFiles;  
	String myTargetType;
	File myFileFromPathManagerStartingJibsFile;
   
   /**
	 * Used to store to and restore from a file store.
	 * @param rootDirectory
	 * @return
	 */
   // iCountTargetFiles ViewerPreferences.countImageFilesInNodes()
	// fileFromPathManagerStartingJibsFile = PathManager.getStartingJibsFile();
	public DTNReaderWriter(String targetType, boolean countTargetFiles, File fileFromPathManagerStartingJibsFile)
	{
		this.myTargetType = targetType;
		this.iCountTargetFiles = countTargetFiles;
		this.myFileFromPathManagerStartingJibsFile = fileFromPathManagerStartingJibsFile;
	}
	
	public DTNWriter getWriter()
	{
		return new DTNWriter(this);
	}
	
	public DTNReader getReader(File file, DirectoryTree tree, ILoadingMessage loadingMsg)
	{
		return new DTNReader(file, tree, loadingMsg, this);
	}
	
	public String getFileName()
	{
		if (this.myTargetType != null)
		{
			return "JibsTree_" + this.myTargetType + ".txt";
		}
		return "JibsTree.txt";
	}
}
