/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */
package org.gerhardb.lib.dirtree;

import java.io.*;
import org.gerhardb.lib.scroller.ListMaker;
import org.gerhardb.lib.util.startup.ILoadingMessage;
import org.gerhardb.lib.util.ModalProgressDialogFlex;

/**
 * A directory node designed to count its files and populate
 * all of its sub-directories.
 * <p>
 * The sub-directory population occurs in a depth-first fashion.
 * Specifically, for a given root, its children are identified and files counted.
 * Then the same recursively occurs for each sub-directory of the root.
 * <p>
 * This allows the highest level directory to be displayed immediately while
 * other directories are populating.  If a user chooses an unpopulated
 * sub-directory, then that sub-directory is immediately populated, but its
 * children are not recursed until the normal time.
 * <p>
 * This is ALWAYS a directory and is tested on construction.
 */
public class DirectoryTreeNodeRDP
   extends DirectoryTreeNode
{
	private DirectoryTreeRDP myRDPtree;

   // ==========================================================================
   // Constructor
   // ==========================================================================
   public DirectoryTreeNodeRDP(DirectoryTreeRDP tree, File f, ILoadingMessage loadingMsg)
      throws FileNotFoundException
   {
   	super(tree, f, loadingMsg);
      this.myRDPtree = tree;
   }
  
   @Override
	public void reloadNodes(ModalProgressDialogFlex flex)
	{
   	super.reloadNodes(flex);

		// TODO FOO UGLY
		// If called from ExplorerBox under JDiskUsage, this will be null and we've finished what we need to.
		// Need to split functions later.
		if (this.myRDPtree.myRDPmanager == null)
		{
			return;
		}
		
		// Adjust any nodes that changed underneath.
		// Particularly repeat.
		this.myRDPtree.myRDPmanager.rescan();
		
		// See if any of the nodes we are showing changed.
		ListMaker lm = this.myRDPtree.getScroller().getListMaker();
		if (lm instanceof DTNListFactory)
		{
			DTNListFactory dlf = (DTNListFactory) lm;
			if (dlf.nodesUpdated(this))
			{
				this.myRDPtree.getScroller().reloadScroller();
			}
		}
	}
   
   @Override
	protected void renameDirUpdateOther(String fullOldName, String fullNewName)
   {
      // See if we renamed any directory we are tracking.
      if (this.myRDPtree.getPlugins() != null)
      {
      	this.myRDPtree.getPlugins().updateDirNameIfNeeded(fullOldName, fullNewName, this);
      }
   }
}