/*
 * Copyright (c) 2007 Gerhard Beck.  All rights reserved.
 *
 * Subject to the GNU GENERAL PUBLIC LICENSE,
 * Version 3, 29 June 2007 http://www.gnu.org/licenses/gpl.html
 *
 * THIS SOFTWARE IS PROVIDED "AS IS" AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL GERHARD BECK OR
 * OTHER CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

package org.gerhardb.lib.dirtree;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;

import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.tree.TreePath;

import org.gerhardb.lib.util.startup.AppStarter;

/**
 * Derived from code originally presented in
 * Core Swing Advanced Programming
 * by Kim Topley, Printice Hall PTR, chapter 8.
 */
public class ExtendedDirectoryTreePopUp
   extends JPopupMenu
{
   DirectoryTreeNode myDirectoryNode = null;
	ExtendedDirectoryTree myTree = null;
	protected TreePath myTreePath = null;
   protected boolean iCountImageFilesInNodes;

   // --------------------------------------------------------------------------
   //                           Constructor
   // --------------------------------------------------------------------------
   /**
    * @param sortScreen popped up on
    * @param path path
    */
   public ExtendedDirectoryTreePopUp(ExtendedDirectoryTree dirTree, TreePath path, boolean countImageFilesInNodes)
   {
      super();
      this.myTree = dirTree;
      this.myTreePath = path;
      this.iCountImageFilesInNodes = countImageFilesInNodes;

      //System.out.println("FileTreePopUp Tree: " + tree);
      //System.out.println("FileTreePopUp Path: " + path);

      Object[] selPath = this.myTreePath.getPath();
      Object node = selPath[selPath.length - 1];
      if (node instanceof DirectoryTreeNode)
      {
         this.myDirectoryNode = (DirectoryTreeNode)node;
      }

      JPanel center = new JPanel(new FlowLayout(FlowLayout.CENTER));

      if (this.myDirectoryNode == null)
      {
         center.add(new JLabel(AppStarter.getString("FileTreePopUp.0")), 0); //$NON-NLS-1$
      }
      else
      {
         center.add(new JLabel(this.myDirectoryNode.getName()), 0);
      }

      insert(center, 0);
      addSeparator();

/*
      FileTreePopUp.1=Show Single Directory
      FileTreePopUp.10=Optimize Selected
      FileTreePopUp.11=Directories must be empty to be Deleted.
      FileTreePopUp.12=Show Non-Image Files
      FileTreePopUp.2=Show This Tree
      FileTreePopUp.3=Show Selected Directories
      FileTreePopUp.4=Reload This Tree
      FileTreePopUp.5=New Directory
      FileTreePopUp.6=Rename Directory
      FileTreePopUp.7=Delete Directory
      FileTreePopUp.8=Optimize
      FileTreePopUp.9=Optimize Tree
      FileNamePopUp.0=File Name
      FileNamePopUp.1=Copy
      FileNamePopUp.2=Disable Auto-Copy
      FileNamePopUp.3=Enable Auto-Copy
    */
      
      JMenuItem showOneDirectoryItem = add(AppStarter.getString("FileTreePopUp.1")); //$NON-NLS-1$ 
      JMenuItem showTree = add(AppStarter.getString("FileTreePopUp.2")); //$NON-NLS-1$
      JMenuItem showSelectedDirectories = add(AppStarter.getString("FileTreePopUp.3")); //$NON-NLS-1$
      JMenuItem showNonImageFiles = add(AppStarter.getString("FileTreePopUp.12")); //$NON-NLS-1$
      JMenuItem showTreeStats = add(AppStarter.getString("SortScreen.menu.tools.treestats.label")); //$NON-NLS-1$
      JMenuItem reloadTree = add(AppStarter.getString("FileTreePopUp.4")); //$NON-NLS-1$
      this.addSeparator();
      JMenuItem newDirItem = add(AppStarter.getString("FileTreePopUp.5")); //$NON-NLS-1$
      JMenuItem renameDirItem = add(AppStarter.getString("FileTreePopUp.6")); //$NON-NLS-1$
      JMenuItem deleteDirItem = add(AppStarter.getString("FileTreePopUp.7")); //$NON-NLS-1$
      JMenuItem deleteEmptyDirectories = add("Delete EmptyDirectories");
      deleteDirItem.setToolTipText("Deletes all empyt directorys found in this tree");
      addExtensions();

      if (this.myDirectoryNode == null)
      {
         showOneDirectoryItem.setEnabled(false);
         showNonImageFiles.setEnabled(false);
         newDirItem.setEnabled(false);
         renameDirItem.setEnabled(false);
         deleteDirItem.setEnabled(false);
         deleteEmptyDirectories.setEnabled(false);
         return;
      }

      showTree.setEnabled(false);
      if (this.myDirectoryNode.getChildCount()>0)
      {
         showTree.setEnabled(true);
      }

      showSelectedDirectories.setEnabled(false);
      showTreeStats.setEnabled(true);
      reloadTree.setEnabled(true);

       if (this.myTree.getSelectionCount() > 0)
      {
         showSelectedDirectories.setEnabled(true);
      }

      File[] kids = this.myDirectoryNode.getFile().listFiles();
      if (kids != null && kids.length > 0)
      {
         deleteDirItem.setEnabled(false);
         deleteDirItem.setToolTipText(
            AppStarter.getString("FileTreePopUp.11")); //$NON-NLS-1$
      }      	

      showOneDirectoryItem.addActionListener(
         new ActionListener()
      {
         public void actionPerformed(ActionEvent event)
         {
            //myTree.getFileListManager().setPicDir(myDirectoryNode, false);
         	ExtendedDirectoryTreePopUp.this.myTree.myRDPmanager.getIScrollDirTree().setCurrentDirectory(ExtendedDirectoryTreePopUp.this.myDirectoryNode, false);
         }
      });

      showNonImageFiles.addActionListener(
            new ActionListener()
         {
            public void actionPerformed(ActionEvent event)
            {
               //myTree.getFileListManager().setPicDir(myDirectoryNode, true);
               ExtendedDirectoryTreePopUp.this.myTree.myRDPmanager.getIScrollDirTree().setCurrentDirectory(ExtendedDirectoryTreePopUp.this.myDirectoryNode, true);
            }
         });

      showTree.addActionListener(
         new ActionListener()
      {
         public void actionPerformed(ActionEvent event)
         {
            Enumeration<?> depth = ExtendedDirectoryTreePopUp.this.myDirectoryNode.depthFirstEnumeration();
            ArrayList<Object> list = new ArrayList<Object>();
            while(depth.hasMoreElements())
            {
               list.add(depth.nextElement());
            }
            DirectoryTreeNode[] nodes = new DirectoryTreeNode[list.size()];
            list.toArray(nodes);
            //myTree.getFileListManager().setPicDir(nodes, false);
            ExtendedDirectoryTreePopUp.this.myTree.myRDPmanager.getIScrollDirTree().setCurrentDirectory(nodes, false);
         }
      });

      showSelectedDirectories.addActionListener(
         new ActionListener()
      {
         public void actionPerformed(ActionEvent event)
         {
            TreePath[] paths = ExtendedDirectoryTreePopUp.this.myTree.getSelectionPaths();
            DirectoryTreeNode[] nodes = new DirectoryTreeNode[paths.length];
            for( int i=0; i<paths.length; i++ )
            {
               nodes[i] = (DirectoryTreeNode)paths[i].getLastPathComponent();
            }
            //myTree.getFileListManager().setPicDir(nodes, false);
            ExtendedDirectoryTreePopUp.this.myTree.myRDPmanager.getIScrollDirTree().setCurrentDirectory(nodes, false);
         }
      });
      
      showTreeStats.addActionListener(
            new ActionListener()
            {
               public void actionPerformed(ActionEvent event)
               {
               	ExtendedDirectoryTreePopUp.this.myTree.showStats(ExtendedDirectoryTreePopUp.this.myDirectoryNode, ExtendedDirectoryTreePopUp.this.iCountImageFilesInNodes);
               }
            });

      reloadTree.addActionListener(
         new ActionListener()
      {
         public void actionPerformed(ActionEvent event)
         {
         	ExtendedDirectoryTreePopUp.this.myDirectoryNode.reloadNodes();
         }
      });


      newDirItem.addActionListener(
         new ActionListener()
      {
         public void actionPerformed(ActionEvent event)
         {
            ExtendedDirectoryTreePopUp.this.myDirectoryNode.newSubDir();
         }
      });

      renameDirItem.addActionListener(
         new ActionListener()
      {
         public void actionPerformed(ActionEvent event)
         {
            ExtendedDirectoryTreePopUp.this.myDirectoryNode.renameDir();
         }
      });

      deleteDirItem.addActionListener(
         new ActionListener()
      {
         public void actionPerformed(ActionEvent event)
         {
            ExtendedDirectoryTreePopUp.this.myDirectoryNode.deleteDir();
         }
      });
      
      deleteEmptyDirectories.addActionListener(
            new ActionListener()
            {
               public void actionPerformed(ActionEvent event)
               {
                  ExtendedDirectoryTreePopUp.this.myDirectoryNode.deleteEmptyDirectories();
               }
            });
   }
   
   public DirectoryTreeNode getDirectoryNode()
   {
   	return this.myDirectoryNode;
   }
   
   public ExtendedDirectoryTree getTree()
   {
   	return this.myTree;
   }
   
   protected void addExtensions()
   {
		// Sub-classes can add stuff.
   }
}
